/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.IdGeneratorContractTest;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IdGeneratorImplContractTest
extends IdGeneratorContractTest {
    private EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule.get());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.testDirectory);
    private EphemeralFileSystemAbstraction fs;

    @Before
    public void doBefore() {
        this.fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
    }

    @Override
    protected IdGenerator createIdGenerator(int grabSize) {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        return this.openIdGenerator(grabSize);
    }

    @Override
    protected IdGenerator openIdGenerator(int grabSize) {
        return new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), grabSize, 1000L, false, IdType.NODE, () -> 0L);
    }

    @After
    public void verifyFileCleanup() {
        File file = this.idGeneratorFile();
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    private File idGeneratorFile() {
        return this.testDirectory.file("testIdGenerator.id");
    }
}

