/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

@RunWith(value=Parameterized.class)
public class RecordRelationshipTraversalCursorTest {
    private static final long FIRST_OWNING_NODE = 1L;
    private static final long SECOND_OWNING_NODE = 2L;
    private static final int TYPE = 0;
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule());
    private NeoStores neoStores;
    @Parameterized.Parameter
    public RelationshipDirection direction;
    @Parameterized.Parameter(value=1)
    public boolean dense;

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({RelationshipDirection.LOOP, false}, {RelationshipDirection.LOOP, true}, {RelationshipDirection.OUTGOING, false}, {RelationshipDirection.OUTGOING, true}, {RelationshipDirection.INCOMING, false}, {RelationshipDirection.INCOMING, true});
    }

    @Before
    public void setupStores() {
        DatabaseLayout storeLayout = this.storage.directory().databaseLayout();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
        PageCache pageCache = this.storage.pageCache();
        FileSystemAbstraction fs = this.storage.fileSystem();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(storeLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @After
    public void shutDownStores() {
        this.neoStores.close();
    }

    @Test
    public void retrieveNodeRelationships() {
        this.createNodeRelationships();
        try (RecordRelationshipTraversalCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(1L, 1L);
            Assert.assertTrue((boolean)cursor.next());
            cursor.init(1L, 2L);
            Assert.assertTrue((boolean)cursor.next());
            cursor.init(1L, 3L);
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test
    public void retrieveUsedRelationshipChain() {
        this.createRelationshipChain(4);
        long expectedNodeId = 1L;
        try (RecordRelationshipTraversalCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(1L, 1L);
            while (cursor.next()) {
                Assert.assertEquals((String)"Should load next relationship in a sequence", (long)expectedNodeId++, (long)cursor.entityReference());
            }
        }
    }

    @Test
    public void retrieveRelationshipChainWithUnusedLink() {
        this.neoStores.getRelationshipStore().setHighId(10L);
        this.createRelationshipChain(4);
        this.unUseRecord(3L);
        int[] expectedRelationshipIds = new int[]{1, 2, 4};
        int relationshipIndex = 0;
        try (RecordRelationshipTraversalCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(1L, 1L);
            while (cursor.next()) {
                Assert.assertEquals((String)"Should load next relationship in a sequence", (long)expectedRelationshipIds[relationshipIndex++], (long)cursor.entityReference());
            }
        }
    }

    @Test
    public void shouldHandleDenseNodeWithNoRelationships() {
        try (RecordRelationshipTraversalCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(1L, (long)Record.NO_NEXT_RELATIONSHIP.intValue());
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private void createNodeRelationships() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        if (this.dense) {
            RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(1L, 1L));
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(2L, 2L));
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(3L, 3L));
        }
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(1L, Record.NO_NEXT_RELATIONSHIP.intValue()));
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(2L, Record.NO_NEXT_RELATIONSHIP.intValue()));
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(3L, Record.NO_NEXT_RELATIONSHIP.intValue()));
    }

    private void unUseRecord(long recordId) {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        RelationshipRecord relationshipRecord = (RelationshipRecord)relationshipStore.getRecord(recordId, (AbstractBaseRecord)new RelationshipRecord(-1L), RecordLoad.FORCE);
        relationshipRecord.setInUse(false);
        relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord);
    }

    private RelationshipGroupRecord createRelationshipGroup(long id, long relationshipId) {
        return new RelationshipGroupRecord(id, 0, this.getFirstOut(relationshipId), this.getFirstIn(relationshipId), this.getFirstLoop(relationshipId), 1L, true);
    }

    private long getFirstLoop(long firstLoop) {
        return this.direction == RelationshipDirection.LOOP ? firstLoop : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private long getFirstIn(long firstIn) {
        return this.direction == RelationshipDirection.INCOMING ? firstIn : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private long getFirstOut(long firstOut) {
        return this.direction == RelationshipDirection.OUTGOING ? firstOut : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private void createRelationshipChain(int recordsInChain) {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        for (int i = 1; i < recordsInChain; ++i) {
            relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(i, i + 1));
        }
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(recordsInChain, Record.NO_NEXT_RELATIONSHIP.intValue()));
        if (this.dense) {
            RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
            for (int i = 1; i < recordsInChain; ++i) {
                relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(i, i));
            }
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(recordsInChain, Record.NO_NEXT_RELATIONSHIP.intValue()));
        }
    }

    private RelationshipRecord createRelationship(long id, long nextRelationship) {
        return new RelationshipRecord(id, true, this.getFirstNode(), this.getSecondNode(), 0, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), nextRelationship, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), nextRelationship, false, false);
    }

    private long getSecondNode() {
        return this.getFirstNode() == 1L ? 2L : 1L;
    }

    private long getFirstNode() {
        return this.direction == RelationshipDirection.OUTGOING ? 1L : 2L;
    }

    private RecordRelationshipTraversalCursor getNodeRelationshipCursor() {
        return new RecordRelationshipTraversalCursor(this.neoStores.getRelationshipStore(), this.neoStores.getRelationshipGroupStore());
    }
}

