/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService queryService;
    private KernelStatement initialStatement;
    private ThreadToStatementContextBridge txBridge;
    private ConfiguredExecutionStatistics statistics;

    @Before
    public void setUp() {
        this.setUpMocks();
    }

    @Test
    public void checkKernelStatementOnCheck() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Kernel kernel = (Kernel)Mockito.mock(Kernel.class);
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        KernelTransaction kernelTransaction = this.mockTransaction((Statement)this.initialStatement);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)kernelTransaction);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, txBridge, null, initialTransaction, (Statement)this.initialStatement, null, kernel);
        transactionalContext.check();
        ((KernelTransaction)Mockito.verify((Object)kernelTransaction)).assertOpen();
    }

    @Test
    public void neverStopsExecutingQueryDuringCommitAndRestartTx() {
        KernelTransaction initialKTX = this.mockTransaction((Statement)this.initialStatement);
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Transaction.Type transactionType = Transaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = null;
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        KernelTransaction secondKTX = this.mockTransaction(secondStatement);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)secondTransaction.terminationReason()).thenReturn(Optional.empty());
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)this.queryService.beginTransaction(transactionType, (LoginContext)securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{initialKTX, secondKTX});
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Kernel kernel = (Kernel)Mockito.mock(Kernel.class);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.queryService, txBridge, locker, initialTransaction, (Statement)this.initialStatement, executingQuery, kernel);
        context.commitAndRestartTx();
        Object[] mocks = new Object[]{txBridge, initialTransaction, initialKTX, initialQueryRegistry, secondQueryRegistry, secondKTX};
        InOrder order = Mockito.inOrder((Object[])mocks);
        ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
        ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((InternalTransaction)order.verify((Object)initialTransaction)).terminationReason();
        ((KernelTransaction)order.verify((Object)initialKTX)).executionStatistics();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((KernelTransaction)order.verify((Object)secondKTX)).acquireStatement();
        ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
        ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
        ((InternalTransaction)order.verify((Object)initialTransaction)).success();
        ((InternalTransaction)order.verify((Object)initialTransaction)).close();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    @Test
    public void rollsBackNewlyCreatedTransactionIfTerminationDetectedOnCloseDuringPeriodicCommit() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Transaction.Type transactionType = Transaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Statement initialStatement = (Statement)Mockito.mock(Statement.class);
        KernelTransaction initialKTX = this.mockTransaction(initialStatement);
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = new PropertyContainerLocker();
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        KernelTransaction secondKTX = this.mockTransaction(secondStatement);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)secondTransaction.terminationReason()).thenReturn(Optional.empty());
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        ((InternalTransaction)Mockito.doThrow(RuntimeException.class).when((Object)initialTransaction)).close();
        Mockito.when((Object)initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)queryService.beginTransaction(transactionType, (LoginContext)securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{initialKTX, secondKTX});
        Mockito.when((Object)txBridge.get()).thenReturn((Object)secondStatement);
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Kernel kernel = (Kernel)Mockito.mock(Kernel.class);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(queryService, txBridge, locker, initialTransaction, initialStatement, executingQuery, kernel);
        try {
            context.commitAndRestartTx();
            throw new AssertionError((Object)"Expected RuntimeException to be thrown");
        }
        catch (RuntimeException e) {
            Object[] mocks = new Object[]{txBridge, initialTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX, secondTransaction};
            InOrder order = Mockito.inOrder((Object[])mocks);
            ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
            ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((InternalTransaction)order.verify((Object)initialTransaction)).terminationReason();
            ((KernelTransaction)order.verify((Object)initialKTX)).executionStatistics();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((KernelTransaction)order.verify((Object)secondKTX)).acquireStatement();
            ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
            ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
            ((InternalTransaction)order.verify((Object)initialTransaction)).success();
            ((InternalTransaction)order.verify((Object)initialTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
            ((InternalTransaction)order.verify((Object)secondTransaction)).failure();
            ((InternalTransaction)order.verify((Object)secondTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            Mockito.verifyNoMoreInteractions((Object[])mocks);
            return;
        }
    }

    @Test
    public void accumulateExecutionStatisticOverCommitAndRestart() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        Kernel kernel = (Kernel)Mockito.mock(Kernel.class);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(this.queryService, this.txBridge, null, initialTransaction, (Statement)this.initialStatement, null, kernel);
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        StatisticProvider statisticProvider = transactionalContext.kernelStatisticProvider();
        Assert.assertEquals((String)"Expect to see accumulated number of page cache misses.", (long)6L, (long)statisticProvider.getPageCacheMisses());
        Assert.assertEquals((String)"Expected to see accumulated number of page cache hits.", (long)15L, (long)statisticProvider.getPageCacheHits());
    }

    @Test
    public void shouldBeOpenAfterCreation() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertTrue((boolean)context.isOpen());
    }

    @Test
    public void shouldBeTopLevelWithImplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)Transaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertTrue((boolean)context.isTopLevelTx());
    }

    @Test
    public void shouldNotBeTopLevelWithExplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)Transaction.Type.explicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertFalse((boolean)context.isTopLevelTx());
    }

    @Test
    public void shouldNotCloseTransactionDuringTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)Transaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldBePossibleToCloseAfterTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)Transaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
        context.close(false);
        ((InternalTransaction)Mockito.verify((Object)tx)).failure();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
    }

    @Test
    public void shouldBePossibleToTerminateWithoutActiveTransaction() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close(true);
        ((InternalTransaction)Mockito.verify((Object)tx)).success();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).terminate();
    }

    @Test
    public void shouldThrowWhenRestartedAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable(terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        try {
            context.commitAndRestartTx();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void shouldThrowWhenGettingTxAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable(terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        try {
            context.getOrBeginNewIfClosed();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void shouldNotBePossibleToCloseMultipleTimes() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close(false);
        context.close(true);
        context.close(false);
        ((InternalTransaction)Mockito.verify((Object)tx)).failure();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).success();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
    }

    private void setUpMocks() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        this.initialStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.statistics = new ConfiguredExecutionStatistics();
        QueryRegistryOperations queryRegistryOperations = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)internalTransaction.terminationReason()).thenReturn(Optional.empty());
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)queryRegistryOperations);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)this.txBridge);
        Mockito.when((Object)this.queryService.beginTransaction((Transaction.Type)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any())).thenReturn((Object)internalTransaction);
        KernelTransaction mockTransaction = this.mockTransaction((Statement)this.initialStatement);
        Mockito.when((Object)this.txBridge.get()).thenReturn((Object)this.initialStatement);
        Mockito.when((Object)this.txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)mockTransaction);
    }

    private Neo4jTransactionalContext newContext(InternalTransaction initialTx) {
        return new Neo4jTransactionalContext(this.queryService, this.txBridge, new PropertyContainerLocker(), initialTx, (Statement)this.initialStatement, null, null);
    }

    private KernelTransaction mockTransaction(Statement statement) {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)kernelTransaction.executionStatistics()).thenReturn((Object)this.statistics);
        Mockito.when((Object)kernelTransaction.acquireStatement()).thenReturn((Object)statement);
        return kernelTransaction;
    }

    private class ConfiguredExecutionStatistics
    implements ExecutionStatistics {
        private long hits;
        private long faults;

        private ConfiguredExecutionStatistics() {
        }

        public long pageHits() {
            return this.hits;
        }

        public long pageFaults() {
            return this.faults;
        }

        void setHits(long hits) {
            this.hits = hits;
        }

        void setFaults(long faults) {
            this.faults = faults;
        }
    }
}

