/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.ListConverter;

public class ListConverterTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldHandleNullString() {
        ListConverter converter = new ListConverter(String.class, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
        String listString = "null";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(null, (Neo4jTypes.AnyType)Neo4jTypes.NTString)));
    }

    @Test
    public void shouldHandleEmptyList() {
        ListConverter converter = new ListConverter(String.class, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
        String listString = "[]";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Collections.emptyList(), (Neo4jTypes.AnyType)Neo4jTypes.NTString)));
    }

    @Test
    public void shouldHandleEmptyListWithSpaces() {
        ListConverter converter = new ListConverter(String.class, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
        String listString = " [  ]   ";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Collections.emptyList(), (Neo4jTypes.AnyType)Neo4jTypes.NTString)));
    }

    @Test
    public void shouldHandleSingleQuotedValue() {
        ListConverter converter = new ListConverter(String.class, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
        String listString = "['foo', 'bar']";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList("foo", "bar"), (Neo4jTypes.AnyType)Neo4jTypes.NTString)));
    }

    @Test
    public void shouldHandleDoubleQuotedValue() {
        ListConverter converter = new ListConverter(String.class, (Neo4jTypes.AnyType)Neo4jTypes.NTString);
        String listString = "[\"foo\", \"bar\"]";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList("foo", "bar"), (Neo4jTypes.AnyType)Neo4jTypes.NTString)));
    }

    @Test
    public void shouldHandleIntegerValue() {
        ListConverter converter = new ListConverter(Long.class, (Neo4jTypes.AnyType)Neo4jTypes.NTInteger);
        String listString = "[1337, 42]";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList(1337L, 42L), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger)));
    }

    @Test
    public void shouldHandleFloatValue() {
        ListConverter converter = new ListConverter(Double.class, (Neo4jTypes.AnyType)Neo4jTypes.NTFloat);
        String listSting = "[2.718281828, 3.14]";
        DefaultParameterValue converted = converter.apply(listSting);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList(2.718281828, 3.14), (Neo4jTypes.AnyType)Neo4jTypes.NTFloat)));
    }

    @Test
    public void shouldHandleNullValue() {
        ListConverter converter = new ListConverter(Double.class, (Neo4jTypes.AnyType)Neo4jTypes.NTFloat);
        String listString = "[null]";
        DefaultParameterValue converted = converter.apply(listString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Collections.singletonList(null), (Neo4jTypes.AnyType)Neo4jTypes.NTFloat)));
    }

    @Test
    public void shouldHandleBooleanValues() {
        ListConverter converter = new ListConverter(Boolean.class, (Neo4jTypes.AnyType)Neo4jTypes.NTBoolean);
        String mapString = "[false, true]";
        DefaultParameterValue converted = converter.apply(mapString);
        Assert.assertThat((Object)converted, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList(false, true), (Neo4jTypes.AnyType)Neo4jTypes.NTBoolean)));
    }

    @Test
    public void shouldHandleNestedLists() {
        ParameterizedType type = (ParameterizedType)Mockito.mock(ParameterizedType.class);
        Mockito.when((Object)type.getActualTypeArguments()).thenReturn((Object)new Type[]{Object.class});
        ListConverter converter = new ListConverter((Type)type, (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTAny));
        String mapString = "[42, [42, 1337]]";
        DefaultParameterValue converted = converter.apply(mapString);
        List list = (List)converted.value();
        Assert.assertThat(list.get(0), (Matcher)CoreMatchers.equalTo((Object)42L));
        Assert.assertThat(list.get(1), (Matcher)CoreMatchers.equalTo(Arrays.asList(42L, 1337L)));
    }

    @Test
    public void shouldFailOnInvalidMixedTyoes() {
        ListConverter converter = new ListConverter(Long.class, (Neo4jTypes.AnyType)Neo4jTypes.NTInteger);
        String listString = "[1337, 'forty-two']";
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Expects a list of Long but got a list of String");
        converter.apply(listString);
    }

    @Test
    public void shouldPassOnValidMixedTyoes() {
        ListConverter converter = new ListConverter(Object.class, Neo4jTypes.NTAny);
        String listString = "[1337, 'forty-two']";
        DefaultParameterValue value = converter.apply(listString);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)DefaultParameterValue.ntList(Arrays.asList(1337L, "forty-two"), (Neo4jTypes.AnyType)Neo4jTypes.NTAny)));
    }

    @Test
    public void shouldHandleListsOfMaps() {
        ListConverter converter = new ListConverter(Map.class, (Neo4jTypes.AnyType)Neo4jTypes.NTMap);
        String mapString = "[{k1: 42}, {k1: 1337}]";
        DefaultParameterValue converted = converter.apply(mapString);
        List list = (List)converted.value();
        Assert.assertThat(list.get(0), (Matcher)CoreMatchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"k1", 42L})));
        Assert.assertThat(list.get(1), (Matcher)CoreMatchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"k1", 1337L})));
    }
}

