/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeValueClientFilterTest
implements IndexProgressor,
IndexProgressor.NodeValueClient {
    @Rule
    public final RandomRule random = new RandomRule();
    private final Read read = (Read)Mockito.mock(Read.class);
    private final List<Event> events = new ArrayList<Event>();
    private final StubNodeCursor node = new StubNodeCursor();
    private final StubPropertyCursor property = new StubPropertyCursor();

    @Test
    public void shouldAcceptAllNodesOnNoFilters() {
        this.node.withNode(17L);
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[0]);
        filter.next();
        Assert.assertTrue((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, new Event.Node(17L, null), Event.CLOSE);
    }

    @Test
    public void shouldRejectNodeNotInUse() {
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    @Test
    public void shouldRejectNodeWithNoProperties() {
        this.node.withNode(17L);
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    @Test
    public void shouldAcceptNodeWithMatchingProperty() {
        this.node.withNode(17L, new long[0], MapUtil.genericMap((Object[])new Object[]{12, Values.stringValue((String)"hello")}));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertTrue((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, new Event.Node(17L, null), Event.CLOSE);
    }

    @Test
    public void shouldNotAcceptNodeWithoutMatchingProperty() {
        this.node.withNode(17L, new long[0], MapUtil.genericMap((Object[])new Object[]{7, Values.stringValue((String)"wrong")}));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assert.assertFalse((boolean)filter.acceptNode(17L, null));
        filter.close();
        this.assertEvents(this.initialize(new int[0]), Event.NEXT, Event.CLOSE);
    }

    @Test
    public void shouldConsultProvidedAcceptingFiltersForMixOfValuesAndNoValues() {
        this.shouldConsultProvidedFilters(Function.identity(), true);
    }

    @Test
    public void shouldConsultProvidedAcceptingFiltersForNullValues() {
        this.shouldConsultProvidedFilters(v -> null, true);
    }

    @Test
    public void shouldConsultProvidedDenyingFiltersForMixOfValuesAndNoValues() {
        this.shouldConsultProvidedFilters(Function.identity(), false);
    }

    @Test
    public void shouldConsultProvidedDenyingFiltersForNullValues() {
        this.shouldConsultProvidedFilters(v -> null, false);
    }

    private void shouldConsultProvidedFilters(Function<Value[], Value[]> filterValues, boolean filterAcceptsValue) {
        long nodeReference = 123L;
        int labelId = 10;
        int slots = this.random.nextInt(3, 8);
        IndexQuery[] filters = new IndexQuery[slots];
        Value[] actualValues = new Value[slots];
        Value[] values = new Value[slots];
        HashMap<Integer, Value> properties = new HashMap<Integer, Value>();
        int[] propertyKeyIds = new int[slots];
        int filterCount = 0;
        for (int i = 0; i < slots; ++i) {
            int propertyKeyId;
            actualValues[i] = this.random.nextValue();
            propertyKeyIds[i] = propertyKeyId = i;
            if (filterCount == 0 && i == slots - 1 || this.random.nextBoolean()) {
                Object filterValue = (filterAcceptsValue ? actualValues[i] : this.anyOtherValueThan(actualValues[i])).asObjectCopy();
                filters[i] = IndexQuery.exact((int)propertyKeyId, (Object)filterValue);
                ++filterCount;
            }
            values[i] = this.random.nextBoolean() ? Values.NO_VALUE : actualValues[i];
            properties.put(propertyKeyId, actualValues[i]);
        }
        this.node.withNode(nodeReference, new long[]{labelId}, properties);
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.NodeValueClient)this, (NodeCursor)this.node, (PropertyCursor)this.property, this.read, filters);
        filter.initialize(TestIndexDescriptorFactory.forLabel(labelId, propertyKeyIds), (IndexProgressor)this, null, IndexOrder.NONE, true);
        boolean accepted = filter.acceptNode(nodeReference, filterValues.apply(values));
        Assert.assertEquals((Object)filterAcceptsValue, (Object)accepted);
    }

    private Value anyOtherValueThan(Value valueToNotReturn) {
        Value candidate;
        while ((candidate = this.random.nextValue()).eq((Object)valueToNotReturn)) {
        }
        return candidate;
    }

    private NodeValueClientFilter initializeFilter(IndexQuery ... filters) {
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.NodeValueClient)this, (NodeCursor)this.node, (PropertyCursor)this.property, this.read, filters);
        filter.initialize(TestIndexDescriptorFactory.forLabel(11, new int[0]), (IndexProgressor)this, null, IndexOrder.NONE, true);
        return filter;
    }

    private void assertEvents(Event ... expected) {
        Assert.assertEquals(Arrays.asList(expected), this.events);
    }

    private Event.Initialize initialize(int ... keys) {
        return new Event.Initialize(this, keys);
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] queries, IndexOrder indexOrder, boolean needsValues) {
        this.events.add(new Event.Initialize(progressor, descriptor.schema().getPropertyIds()));
    }

    public boolean acceptNode(long reference, Value[] values) {
        this.events.add(new Event.Node(reference, values));
        return true;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        this.events.add(Event.NEXT);
        return true;
    }

    public void close() {
        this.events.add(Event.CLOSE);
    }

    private static abstract class Event {
        static final Event CLOSE = new Event(){

            public String toString() {
                return "CLOSE";
            }
        };
        static final Event NEXT = new Event(){

            public String toString() {
                return "NEXT";
            }
        };

        private Event() {
        }

        public final boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        static class Node
        extends Event {
            final long reference;
            final Value[] values;

            Node(long reference, Value[] values) {
                this.reference = reference;
                this.values = values;
            }

            public String toString() {
                return "Node(" + this.reference + "," + Arrays.toString(this.values) + ")";
            }
        }

        static class Initialize
        extends Event {
            final transient IndexProgressor progressor;
            final int[] keys;

            Initialize(IndexProgressor progressor, int[] keys) {
                this.progressor = progressor;
                this.keys = keys;
            }

            public String toString() {
                return "INITIALIZE(" + Arrays.toString(this.keys) + ")";
            }
        }
    }
}

