/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.stream.LongStream;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

public class DefaultRelationshipTraversalCursorTest {
    private DefaultCursors pool = (DefaultCursors)Mockito.mock(DefaultCursors.class);
    private long node = 42L;
    private int type = 9999;
    private int type2 = 9998;
    private long relationship = 100L;
    private long relationshipGroup = 313L;
    private Rel NO_REL = this.rel(-1L, -1L, -1L, -1);

    @Test
    public void regularSparseTraversal() {
        this.regularTraversal(this.relationship);
    }

    @Test
    public void regularSparseTraversalWithTxState() {
        this.regularTraversalWithTxState(this.relationship);
    }

    @Test
    public void regularDenseTraversal() {
        this.regularTraversal(RelationshipReferenceEncoding.encodeGroup((long)this.relationshipGroup));
    }

    @Test
    public void regularDenseTraversalWithTxState() {
        this.regularTraversalWithTxState(RelationshipReferenceEncoding.encodeGroup((long)this.relationshipGroup));
    }

    @Test
    public void sparseTraversalWithTxStateFiltering() {
        StorageRelationshipTraversalCursor storeCursor = this.storeCursor(this.rel(100L, this.node, 50L, this.type), this.rel(102L, this.node, 51L, this.type), this.rel(104L, this.node, 52L, this.type));
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(this.rel(3L, this.node, 50L, this.type), this.rel(4L, 50L, this.node, this.type), this.rel(5L, this.node, 50L, this.type2), this.rel(6L, this.node, this.node, this.type), this.rel(7L, this.node, 52L, this.type));
        cursor.init(this.node, RelationshipReferenceEncoding.encodeForTxStateFiltering((long)this.relationship), read);
        this.assertRelationships(cursor, 100L, 3L, 7L, 102L, 104L);
    }

    @Test
    public void sparseTraversalWithFiltering() {
        StorageRelationshipTraversalCursor storeCursor = this.storeCursor(this.rel(100L, 50L, this.node, this.type), this.rel(101L, this.node, 50L, this.type), this.rel(102L, 50L, this.node, this.type2), this.rel(103L, 51L, this.node, this.type), this.rel(104L, this.node, this.node, this.type));
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(this.rel(3L, this.node, 50L, this.type), this.rel(4L, 50L, this.node, this.type), this.rel(5L, this.node, 50L, this.type2), this.rel(6L, this.node, this.node, this.type), this.rel(7L, this.node, 52L, this.type));
        cursor.init(this.node, RelationshipReferenceEncoding.encodeForFiltering((long)this.relationship), read);
        this.assertRelationships(cursor, 100L, 4L, 103L);
    }

    @Test
    public void emptyStoreOutgoingOfType() {
        StorageRelationshipTraversalCursor storeCursor = this.emptyStoreCursor(new long[0]);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(this.rel(3L, this.node, 50L, this.type), this.rel(4L, 50L, this.node, this.type), this.rel(5L, this.node, 50L, this.type2), this.rel(6L, this.node, this.node, this.type), this.rel(7L, this.node, 52L, this.type));
        cursor.init(this.node, RelationshipReferenceEncoding.encodeNoOutgoingRels((int)this.type), read);
        this.assertRelationships(cursor, 3L, 7L);
    }

    @Test
    public void emptyStoreIncomingOfType() {
        StorageRelationshipTraversalCursor storeCursor = this.emptyStoreCursor(new long[0]);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(this.rel(3L, this.node, 50L, this.type), this.rel(4L, 50L, this.node, this.type), this.rel(5L, 50L, this.node, this.type2), this.rel(6L, this.node, this.node, this.type), this.rel(7L, 56L, this.node, this.type), this.rel(8L, this.node, 52L, this.type));
        cursor.init(this.node, RelationshipReferenceEncoding.encodeNoIncomingRels((int)this.type), read);
        this.assertRelationships(cursor, 4L, 7L);
    }

    @Test
    public void emptyStoreLoopsOfType() {
        StorageRelationshipTraversalCursor storeCursor = this.emptyStoreCursor(new long[0]);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(this.rel(3L, this.node, 50L, this.type), this.rel(2L, this.node, this.node, this.type), this.rel(5L, 50L, this.node, this.type2), this.rel(6L, this.node, this.node, this.type), this.rel(7L, 56L, this.node, this.type), this.rel(8L, this.node, 52L, this.type));
        cursor.init(this.node, RelationshipReferenceEncoding.encodeNoLoopRels((int)this.type), read);
        this.assertRelationships(cursor, 2L, 6L);
    }

    private void regularTraversal(long reference) {
        StorageRelationshipTraversalCursor storeCursor = this.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.emptyTxState();
        cursor.init(this.node, reference, read);
        this.assertRelationships(cursor, 100L, 102L, 104L);
    }

    private void regularTraversalWithTxState(long reference) {
        StorageRelationshipTraversalCursor storeCursor = this.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(this.pool, storeCursor);
        Read read = this.txState(3L, 4L);
        cursor.init(this.node, reference, read);
        this.assertRelationships(cursor, 3L, 4L, 100L, 102L, 104L);
    }

    private Read emptyTxState() {
        return (Read)Mockito.mock(Read.class);
    }

    private Read txState(long ... ids) {
        return this.txState((Rel[])LongStream.of(ids).mapToObj(id -> this.rel(id, this.node, this.node, this.type)).toArray(Rel[]::new));
    }

    private Read txState(Rel ... rels) {
        Read read = (Read)Mockito.mock(Read.class);
        if (rels.length > 0) {
            TxState txState = new TxState();
            for (Rel rel : rels) {
                txState.relationshipDoCreate(rel.relId, rel.type, rel.sourceId, rel.targetId);
            }
            Mockito.when((Object)read.hasTxStateWithChanges()).thenReturn((Object)true);
            Mockito.when((Object)read.txState()).thenReturn((Object)txState);
        }
        return read;
    }

    private void assertRelationships(DefaultRelationshipTraversalCursor cursor, long ... expected) {
        for (long expectedId : expected) {
            Assertions.assertTrue((boolean)cursor.next(), (String)("Expected relationship " + expectedId + " but got none"));
            Assertions.assertEquals((long)expectedId, (long)cursor.relationshipReference(), (String)("Expected relationship " + expectedId + " got " + cursor.relationshipReference()));
        }
        Assertions.assertFalse((boolean)cursor.next(), (String)("Expected no more relationships, but got " + cursor.relationshipReference()));
    }

    private Rel rel(long relId, long startId, long endId, int type) {
        return new Rel(relId, startId, endId, type);
    }

    private StorageRelationshipTraversalCursor emptyStoreCursor(long ... ids) {
        return this.storeCursor(new Rel[0]);
    }

    private StorageRelationshipTraversalCursor storeCursor(long ... ids) {
        return this.storeCursor((Rel[])LongStream.of(ids).mapToObj(id -> this.rel(id, -1L, -1L, -1)).toArray(Rel[]::new));
    }

    private StorageRelationshipTraversalCursor storeCursor(final Rel ... rels) {
        return new StorageRelationshipTraversalCursor(){
            private int i = -1;
            private Rel rel = DefaultRelationshipTraversalCursorTest.access$000(DefaultRelationshipTraversalCursorTest.this);

            public long neighbourNodeReference() {
                return this.rel.sourceId == DefaultRelationshipTraversalCursorTest.this.node ? this.rel.targetId : this.rel.sourceId;
            }

            public long originNodeReference() {
                return DefaultRelationshipTraversalCursorTest.this.node;
            }

            public void init(long nodeReference, long reference) {
            }

            public int type() {
                return this.rel.type;
            }

            public long sourceNodeReference() {
                return this.rel.sourceId;
            }

            public long targetNodeReference() {
                return this.rel.targetId;
            }

            public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
                this.rel = DefaultRelationshipTraversalCursorTest.this.rel(relationshipId, startNodeId, endNodeId, typeId);
            }

            public boolean hasProperties() {
                throw new UnsupportedOperationException("not implemented");
            }

            public long propertiesReference() {
                throw new UnsupportedOperationException("not implemented");
            }

            public long entityReference() {
                return this.rel.relId;
            }

            public boolean next() {
                ++this.i;
                if (this.i < 0 || this.i >= rels.length) {
                    this.rel = DefaultRelationshipTraversalCursorTest.this.NO_REL;
                    return false;
                }
                this.rel = rels[this.i];
                return true;
            }

            public void reset() {
            }

            public void close() {
            }
        };
    }

    private class Rel {
        final long relId;
        final long sourceId;
        final long targetId;
        final int type;

        Rel(long relId, long sourceId, long targetId, int type) {
            this.relId = relId;
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.type = type;
        }
    }
}

