/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.kernel.api.helpers.StubRead;
import org.neo4j.kernel.impl.newapi.CursorPropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class CursorPropertyAccessorTest {
    @Test
    public void shouldLookupProperty() throws EntityNotFoundException {
        long nodeId = 10L;
        Value value = Values.of((Object)"abc");
        int propertyKeyId = 0;
        StubNodeCursor nodeCursor = new StubNodeCursor().withNode(nodeId, new long[0], MapUtil.genericMap((Object[])new Object[]{999, Values.of((Object)12345), propertyKeyId, value}));
        CursorPropertyAccessor accessor = new CursorPropertyAccessor((NodeCursor)nodeCursor, (PropertyCursor)new StubPropertyCursor(), (Read)new StubRead());
        Value readValue = accessor.getNodePropertyValue(nodeId, propertyKeyId);
        Assert.assertEquals((Object)value, (Object)readValue);
    }

    @Test
    public void shouldReturnNoValueOnMissingProperty() throws EntityNotFoundException {
        long nodeId = 10L;
        StubNodeCursor nodeCursor = new StubNodeCursor().withNode(nodeId, new long[0], MapUtil.genericMap((Object[])new Object[]{999, Values.of((Object)12345)}));
        CursorPropertyAccessor accessor = new CursorPropertyAccessor((NodeCursor)nodeCursor, (PropertyCursor)new StubPropertyCursor(), (Read)new StubRead());
        Value readValue = accessor.getNodePropertyValue(nodeId, 0);
        Assert.assertEquals((Object)Values.NO_VALUE, (Object)readValue);
    }

    @Test
    public void shouldThrowOnEntityNotFound() {
        long nodeId = 10L;
        Value value = Values.of((Object)"abc");
        int propertyKeyId = 0;
        StubNodeCursor nodeCursor = new StubNodeCursor().withNode(nodeId, new long[0], MapUtil.genericMap((Object[])new Object[]{999, Values.of((Object)12345), propertyKeyId, value}));
        CursorPropertyAccessor accessor = new CursorPropertyAccessor((NodeCursor)nodeCursor, (PropertyCursor)new StubPropertyCursor(), (Read)new StubRead());
        try {
            accessor.getNodePropertyValue(nodeId + 1L, propertyKeyId);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }
}

