/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;

public class InstanceSelectorTest {
    @Test
    public void shouldSelect() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0", IndexSlot.STRING, "1");
        String select0 = (String)selector.select(IndexSlot.NUMBER);
        Assert.assertEquals((Object)"0", (Object)select0);
        String select1 = (String)selector.select(IndexSlot.STRING);
        Assert.assertEquals((Object)"1", (Object)select1);
    }

    @Test
    public void shouldThrowOnNonInstantiatedSelect() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0");
        try {
            selector.select(IndexSlot.STRING);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnNonInstantiatedFlatMap() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0");
        try {
            selector.transform(Integer::parseInt);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnNonInstantiatedMap() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0");
        try {
            selector.map(Integer::parseInt);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFlatMap() {
        InstanceSelector<String> selector = this.selectorFilledWithOrdinal();
        List actual = Iterables.asList((Iterable)selector.transform(Integer::parseInt));
        List expected = Arrays.stream(IndexSlot.values()).map(Enum::ordinal).collect(Collectors.toList());
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (Integer i : expected) {
            Assert.assertTrue((boolean)actual.contains(i));
        }
    }

    @Test
    public void shouldMap() {
        InstanceSelector<String> selector = this.selectorFilledWithOrdinal();
        EnumMap actual = selector.map(Integer::parseInt);
        for (IndexSlot slot : IndexSlot.values()) {
            Assert.assertEquals((long)slot.ordinal(), (long)((Integer)actual.get(slot)).intValue());
        }
    }

    @Test
    public void shouldThrowOnNonInstantiatedForAll() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0");
        try {
            selector.forAll(Integer::parseInt);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldForAll() {
        InstanceSelector<String> selector = this.selectorFilledWithOrdinal();
        MutableInt count = new MutableInt();
        selector.forAll(s -> count.increment());
        Assert.assertEquals((long)IndexSlot.values().length, (long)count.intValue());
    }

    @Test
    public void shouldNotThrowOnNonInstantiatedClose() {
        InstanceSelector<String> selector = this.selector(IndexSlot.NUMBER, "0");
        selector.close(Integer::parseInt);
    }

    @Test
    public void shouldCloseAll() {
        InstanceSelector<String> selector = this.selectorFilledWithOrdinal();
        MutableInt count = new MutableInt();
        selector.close(s -> count.increment());
        Assert.assertEquals((long)IndexSlot.values().length, (long)count.intValue());
    }

    private InstanceSelector<String> selector(Object ... mapping) {
        EnumMap<IndexSlot, String> map = new EnumMap<IndexSlot, String>(IndexSlot.class);
        int i = 0;
        while (i < mapping.length) {
            map.put((IndexSlot)mapping[i++], (String)mapping[i++]);
        }
        return new InstanceSelector(map);
    }

    private InstanceSelector<String> selectorFilledWithOrdinal() {
        EnumMap<IndexSlot, String> map = new EnumMap<IndexSlot, String>(IndexSlot.class);
        for (IndexSlot slot : IndexSlot.values()) {
            map.put(slot, Integer.toString(slot.ordinal()));
        }
        return new InstanceSelector(map);
    }
}

