/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class FusionIndexTestHelp {
    private static LabelSchemaDescriptor indexKey = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static LabelSchemaDescriptor compositeIndexKey = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
    private static final Value[] stringValues = new Value[]{Values.stringValue((String)"abc"), Values.stringValue((String)"abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6"), Values.charValue((char)'S')};
    private static final Value[] numberValues = new Value[]{Values.byteValue((byte)1), Values.shortValue((short)2), Values.intValue((int)3), Values.longValue((long)4L), Values.floatValue((float)5.6f), Values.doubleValue((double)7.8)};
    private static final Value[] pointValues = new Value[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{123.0, 456.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{123.0, 456.0, 789.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{13.2, 56.8})};
    private static final Value[] temporalValues = new Value[]{DateValue.epochDate((long)1L), DateValue.epochDate((long)10000L)};
    private static final Value[] otherValues = new Value[]{Values.booleanValue((boolean)true), Values.booleanArray((boolean[])new boolean[2]), Values.byteArray((byte[])new byte[]{1, 2}), Values.shortArray((short[])new short[]{3, 4}), Values.intArray((int[])new int[]{5, 6}), Values.longArray((long[])new long[]{7L, 8L}), Values.floatArray((float[])new float[]{9.1f, 11.12f}), Values.doubleArray((double[])new double[]{13.14, 15.16}), Values.charArray((char[])new char[2]), Values.stringArray((String[])new String[]{"a", "b"}), Values.pointArray((Value[])pointValues), Values.NO_VALUE};

    FusionIndexTestHelp() {
    }

    static Value[] valuesSupportedByString() {
        return stringValues;
    }

    static Value[] valuesSupportedByNumber() {
        return numberValues;
    }

    static Value[] valuesSupportedBySpatial() {
        return pointValues;
    }

    static Value[] valuesSupportedByTemporal() {
        return temporalValues;
    }

    static Value[] valuesNotSupportedBySpecificIndex() {
        return otherValues;
    }

    static Value[] allValues() {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Value[] group : FusionIndexTestHelp.valuesByGroup().values()) {
            values.addAll(Arrays.asList(group));
        }
        return values.toArray(new Value[0]);
    }

    static EnumMap<IndexSlot, Value[]> valuesByGroup() {
        EnumMap<IndexSlot, Value[]> values = new EnumMap<IndexSlot, Value[]>(IndexSlot.class);
        values.put(IndexSlot.STRING, FusionIndexTestHelp.valuesSupportedByString());
        values.put(IndexSlot.NUMBER, FusionIndexTestHelp.valuesSupportedByNumber());
        values.put(IndexSlot.SPATIAL, FusionIndexTestHelp.valuesSupportedBySpatial());
        values.put(IndexSlot.TEMPORAL, FusionIndexTestHelp.valuesSupportedByTemporal());
        values.put(IndexSlot.LUCENE, FusionIndexTestHelp.valuesNotSupportedBySpecificIndex());
        return values;
    }

    static void verifyCallFail(Exception expectedFailure, Callable failingCall) {
        try {
            failingCall.call();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> add(Value ... value) {
        switch (value.length) {
            case 1: {
                return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)indexKey, (Value[])value);
            }
            case 2: {
                return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)compositeIndexKey, (Value[])value);
            }
        }
        return null;
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> remove(Value ... value) {
        switch (value.length) {
            case 1: {
                return IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)indexKey, (Value[])value);
            }
            case 2: {
                return IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)compositeIndexKey, (Value[])value);
            }
        }
        return null;
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> change(Value[] before, Value[] after) {
        return IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)compositeIndexKey, (Value[])before, (Value[])after);
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> change(Value before, Value after) {
        return IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)indexKey, (Value)before, (Value)after);
    }

    static void verifyOtherIsClosedOnSingleThrow(AutoCloseable failingCloseable, AutoCloseable fusionCloseable, AutoCloseable ... successfulCloseables) throws Exception {
        UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)failingCloseable)).close();
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
        for (AutoCloseable successfulCloseable : successfulCloseables) {
            ((AutoCloseable)Mockito.verify((Object)successfulCloseable, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    static void verifyFusionCloseThrowOnSingleCloseThrow(AutoCloseable failingCloseable, AutoCloseable fusionCloseable) throws Exception {
        UncheckedIOException expectedFailure = new UncheckedIOException(new IOException("fail"));
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{expectedFailure}).when((Object)failingCloseable)).close();
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
    }

    static void verifyFusionCloseThrowIfAllThrow(AutoCloseable fusionCloseable, AutoCloseable ... autoCloseables) throws Exception {
        UncheckedIOException[] failures = new UncheckedIOException[autoCloseables.length];
        for (int i = 0; i < autoCloseables.length; ++i) {
            failures[i] = new UncheckedIOException(new IOException("unknown"));
            ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{failures[i]}).when((Object)autoCloseables[i])).close();
        }
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException e) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            for (UncheckedIOException failure : failures) {
                matchers.add(Matchers.sameInstance((Object)failure));
            }
            Assert.assertThat((Object)e, (Matcher)AnyOf.anyOf(matchers));
        }
    }

    static <T> void fill(EnumMap<IndexSlot, T> map, T instance) {
        for (IndexSlot slot : IndexSlot.values()) {
            map.put(slot, instance);
        }
    }
}

