/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;

@RunWith(value=Parameterized.class)
public class FusionIndexProviderTest {
    private static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("test-fusion", "1");
    public static final StoreIndexDescriptor AN_INDEX = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withId(0L);
    private EnumMap<IndexSlot, IndexProvider> providers;
    private IndexProvider[] aliveProviders;
    private IndexProvider fusionIndexProvider;
    private SlotSelector slotSelector;
    private InstanceSelector<IndexProvider> instanceSelector;
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;
    @Rule
    public RandomRule random = new RandomRule();

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.slotSelector = fusionVersion.slotSelector();
        this.setupMocks();
    }

    private void setupMocks() {
        IndexSlot[] aliveSlots = fusionVersion.aliveSlots();
        this.aliveProviders = new IndexProvider[aliveSlots.length];
        this.providers = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.providers, IndexProvider.EMPTY);
        block7: for (int i = 0; i < aliveSlots.length; ++i) {
            switch (aliveSlots[i]) {
                case STRING: {
                    IndexProvider string = FusionIndexProviderTest.mockProvider(StringIndexProvider.class, "string");
                    this.providers.put(IndexSlot.STRING, string);
                    this.aliveProviders[i] = string;
                    continue block7;
                }
                case NUMBER: {
                    IndexProvider number = FusionIndexProviderTest.mockProvider(NumberIndexProvider.class, "number");
                    this.providers.put(IndexSlot.NUMBER, number);
                    this.aliveProviders[i] = number;
                    continue block7;
                }
                case SPATIAL: {
                    IndexProvider spatial = FusionIndexProviderTest.mockProvider(SpatialIndexProvider.class, "spatial");
                    this.providers.put(IndexSlot.SPATIAL, spatial);
                    this.aliveProviders[i] = spatial;
                    continue block7;
                }
                case TEMPORAL: {
                    IndexProvider temporal = FusionIndexProviderTest.mockProvider(TemporalIndexProvider.class, "temporal");
                    this.providers.put(IndexSlot.TEMPORAL, temporal);
                    this.aliveProviders[i] = temporal;
                    continue block7;
                }
                case LUCENE: {
                    IndexProvider lucene = FusionIndexProviderTest.mockProvider(IndexProvider.class, "lucene");
                    this.providers.put(IndexSlot.LUCENE, lucene);
                    this.aliveProviders[i] = lucene;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexProvider = new FusionIndexProvider(this.providers.get(IndexSlot.STRING), this.providers.get(IndexSlot.NUMBER), this.providers.get(IndexSlot.SPATIAL), this.providers.get(IndexSlot.TEMPORAL), this.providers.get(IndexSlot.LUCENE), fusionVersion.slotSelector(), DESCRIPTOR, IndexDirectoryStructure.NONE, (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), false);
        this.instanceSelector = new InstanceSelector(this.providers);
    }

    private static IndexProvider mockProvider(Class<? extends IndexProvider> providerClass, String name) {
        IndexProvider mock = (IndexProvider)Mockito.mock(providerClass);
        Mockito.when((Object)mock.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor(name, "1"));
        return mock;
    }

    @Test
    public void mustSelectCorrectTargetForAllGivenValueCombinations() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            Value[] group;
            Value[] valueArray = group = values.get(indexSlot);
            int n = valueArray.length;
            for (int i = 0; i < n; ++i) {
                Value value = valueArray[i];
                IndexProvider selected = (IndexProvider)this.instanceSelector.select(this.slotSelector.selectSlot(ArrayUtil.array((Object[])new Value[]{value}), FusionIndexBase.GROUP_OF));
                Assert.assertSame((Object)this.orLucene(this.providers.get(indexSlot)), (Object)selected);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                IndexProvider selected = (IndexProvider)this.instanceSelector.select(this.slotSelector.selectSlot(ArrayUtil.array((Object[])new Value[]{indexSlot, secondValue}), FusionIndexBase.GROUP_OF));
                Assert.assertSame((Object)this.providers.get(IndexSlot.LUCENE), (Object)selected);
            }
        }
    }

    @Test
    public void mustCombineSamples() {
        int sumIndexSize = 0;
        int sumUniqueValues = 0;
        int sumSampleSize = 0;
        IndexSample[] samples = new IndexSample[this.providers.size()];
        for (int i = 0; i < samples.length; ++i) {
            int indexSize = this.random.nextInt(0, 1000000);
            int uniqueValues = this.random.nextInt(0, 1000000);
            int sampleSize = this.random.nextInt(0, 1000000);
            samples[i] = new IndexSample((long)indexSize, (long)uniqueValues, (long)sampleSize);
            sumIndexSize += indexSize;
            sumUniqueValues += uniqueValues;
            sumSampleSize += sampleSize;
        }
        IndexSample fusionSample = FusionIndexSampler.combineSamples(Arrays.asList(samples));
        Assert.assertEquals((long)sumIndexSize, (long)fusionSample.indexSize());
        Assert.assertEquals((long)sumUniqueValues, (long)fusionSample.uniqueValues());
        Assert.assertEquals((long)sumSampleSize, (long)fusionSample.sampleSize());
    }

    @Test
    public void getPopulationFailureMustThrowIfNoFailure() {
        IllegalStateException failure = new IllegalStateException("not failed");
        for (IndexProvider provider : this.aliveProviders) {
            Mockito.when((Object)provider.getPopulationFailure((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenThrow(new Throwable[]{failure});
        }
        try {
            this.fusionIndexProvider.getPopulationFailure(AN_INDEX);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenAnyFailed() {
        for (IndexProvider failingProvider : this.aliveProviders) {
            String failure = "failure";
            IllegalStateException exception = new IllegalStateException("not failed");
            for (IndexProvider provider : this.aliveProviders) {
                if (provider == failingProvider) {
                    Mockito.when((Object)provider.getPopulationFailure((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenReturn((Object)failure);
                    continue;
                }
                Mockito.when((Object)provider.getPopulationFailure((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenThrow(new Throwable[]{exception});
            }
            Assert.assertThat((Object)this.fusionIndexProvider.getPopulationFailure(AN_INDEX), (Matcher)CoreMatchers.containsString((String)failure));
        }
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenMultipleFail() {
        ArrayList<String> failureMessages = new ArrayList<String>();
        for (IndexProvider aliveProvider : this.aliveProviders) {
            String failureMessage = "FAILURE[" + aliveProvider + "]";
            failureMessages.add(failureMessage);
            Mockito.when((Object)aliveProvider.getPopulationFailure((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenReturn((Object)failureMessage);
        }
        String populationFailure = this.fusionIndexProvider.getPopulationFailure(AN_INDEX);
        for (String failureMessage : failureMessages) {
            Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.containsString((String)failureMessage));
        }
    }

    @Test
    public void shouldReportFailedIfAnyIsFailed() {
        IndexProvider provider = this.fusionIndexProvider;
        for (InternalIndexState state : InternalIndexState.values()) {
            for (IndexProvider failedProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    this.setInitialState(aliveProvider, failedProvider == aliveProvider ? InternalIndexState.FAILED : state);
                }
                InternalIndexState initialState = provider.getInitialState(AN_INDEX);
                Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)initialState);
            }
        }
    }

    @Test
    public void shouldReportPopulatingIfAnyIsPopulating() {
        for (InternalIndexState state : (InternalIndexState[])ArrayUtil.array((Object[])new InternalIndexState[]{InternalIndexState.ONLINE, InternalIndexState.POPULATING})) {
            for (IndexProvider populatingProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    this.setInitialState(aliveProvider, populatingProvider == aliveProvider ? InternalIndexState.POPULATING : state);
                }
                InternalIndexState initialState = this.fusionIndexProvider.getInitialState(AN_INDEX);
                Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)initialState);
            }
        }
    }

    private void setInitialState(IndexProvider mockedProvider, InternalIndexState state) {
        Mockito.when((Object)mockedProvider.getInitialState((StoreIndexDescriptor)ArgumentMatchers.any(StoreIndexDescriptor.class))).thenReturn((Object)state);
    }

    private IndexProvider orLucene(IndexProvider provider) {
        return provider != IndexProvider.EMPTY ? provider : this.providers.get(IndexSlot.LUCENE);
    }
}

