/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class StringIndexKeyTest {
    @Inject
    private RandomRule random;

    StringIndexKeyTest() {
    }

    @Test
    void shouldReuseByteArrayForFairlySimilarSizedKeys() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.setBytesLength(25);
        byte[] second = key.bytes;
        Assert.assertSame((Object)first, (Object)second);
        Assert.assertThat((Object)first.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(25)));
    }

    @Test
    void shouldCreateNewByteArrayForVastlyDifferentKeySizes() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.setBytesLength(100);
        byte[] second = key.bytes;
        Assert.assertNotSame((Object)first, (Object)second);
        Assert.assertThat((Object)first.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(20)));
        Assert.assertThat((Object)second.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(100)));
    }

    @Test
    void shouldDereferenceByteArrayWhenMaterializingValue() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.asValue();
        key.setBytesLength(25);
        byte[] second = key.bytes;
        Assert.assertNotSame((Object)first, (Object)second);
    }

    @Test
    void minimalSplitterForSameValueShouldDivideLeftAndRight() {
        StringLayout layout = new StringLayout();
        StringIndexKey left = layout.newKey();
        StringIndexKey right = layout.newKey();
        StringIndexKey minimalSplitter = layout.newKey();
        TextValue value = this.random.randomValues().nextTextValue();
        left.initialize(1L);
        right.initialize(2L);
        left.initFromValue(0, (Value)value, NativeIndexKey.Inclusion.NEUTRAL);
        right.initFromValue(0, (Value)value, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertTrue((layout.compare((NativeIndexKey)left, (NativeIndexKey)minimalSplitter) < 0 ? 1 : 0) != 0, (String)("Expected minimal splitter to be strictly greater than left but wasn't for value " + value));
        Assertions.assertTrue((layout.compare((NativeIndexKey)minimalSplitter, (NativeIndexKey)right) <= 0 ? 1 : 0) != 0, (String)("Expected right to be greater than or equal to minimal splitter but wasn't for value " + value));
    }

    @Test
    void minimalSplitterShouldRemoveEntityIdIfPossible() {
        StringLayout layout = new StringLayout();
        StringIndexKey left = layout.newKey();
        StringIndexKey right = layout.newKey();
        StringIndexKey minimalSplitter = layout.newKey();
        String string = this.random.nextString();
        TextValue leftValue = Values.stringValue((String)string);
        TextValue rightValue = Values.stringValue((String)(string + this.random.randomValues().nextCharRaw()));
        left.initialize(1L);
        left.initFromValue(0, (Value)leftValue, NativeIndexKey.Inclusion.NEUTRAL);
        right.initialize(2L);
        right.initFromValue(0, (Value)rightValue, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertEquals((long)-1L, (long)minimalSplitter.getEntityId(), (String)("Expected minimal splitter to have entityId removed when constructed from keys with unique values: left=" + leftValue + ", right=" + rightValue));
    }
}

