/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.SimpleIndexDirectoryStructures;
import org.neo4j.kernel.impl.index.schema.StringIndexPopulator;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

class NativeIndexPopulatorTestCases {
    private static final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
    private static final StandardConfiguration configuration = new StandardConfiguration();

    NativeIndexPopulatorTestCases() {
    }

    static Collection<Object[]> allCases() {
        return Arrays.asList({new TestCase<NumberIndexKey, NativeIndexValue>("Number", NativeIndexPopulatorTestCases.numberPopulatorFactory(), RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), NumberLayoutNonUnique::new)}, {new TestCase("String", StringIndexPopulator::new, RandomValues.typesOfGroup((ValueGroup)ValueGroup.TEXT), StringLayout::new)}, {new TestCase("Date", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.DATE), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DATE), DateLayout::new)}, {new TestCase("DateTime", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.ZONED_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_DATE_TIME), ZonedDateTimeLayout::new)}, {new TestCase("Duration", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.DURATION), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DURATION), DurationLayout::new)}, {new TestCase("LocalDateTime", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new)}, {new TestCase("LocalTime", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.LOCAL_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_TIME), LocalTimeLayout::new)}, {new TestCase("LocalDateTime", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new)}, {new TestCase("Time", NativeIndexPopulatorTestCases.temporalPopulatorFactory(ValueGroup.ZONED_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_TIME), ZonedTimeLayout::new)}, {new TestCase<GenericKey, NativeIndexValue>("Generic", NativeIndexPopulatorTestCases.genericPopulatorFactory(), ValueType.values(), () -> new GenericLayout(1, spaceFillingCurveSettings))}, {new TestCase<GenericKey, NativeIndexValue>("Generic-BlockBased", NativeIndexPopulatorTestCases.genericBlockBasedPopulatorFactory(), ValueType.values(), () -> new GenericLayout(1, spaceFillingCurveSettings))});
    }

    private static PopulatorFactory<NumberIndexKey, NativeIndexValue> numberPopulatorFactory() {
        return NumberIndexPopulator::new;
    }

    private static <TK extends NativeIndexSingleValueKey<TK>> PopulatorFactory<TK, NativeIndexValue> temporalPopulatorFactory(ValueGroup temporalValueGroup) {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> {
            TemporalIndexFiles.FileLayout fileLayout = new TemporalIndexFiles.FileLayout(storeFile, layout, temporalValueGroup);
            return new TemporalIndexPopulator.PartPopulator(pageCache, fs, fileLayout, monitor, descriptor);
        };
    }

    private static PopulatorFactory<GenericKey, NativeIndexValue> genericPopulatorFactory() {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> {
            IndexDirectoryStructure directoryStructure = SimpleIndexDirectoryStructures.onIndexFile(storeFile);
            FileSystemIndexDropAction dropAction = new FileSystemIndexDropAction(fs, directoryStructure);
            return new GenericNativeIndexPopulator(pageCache, fs, storeFile, layout, monitor, descriptor, spaceFillingCurveSettings, directoryStructure, (SpaceFillingCurveConfiguration)configuration, (IndexDropAction)dropAction, false);
        };
    }

    private static PopulatorFactory<GenericKey, NativeIndexValue> genericBlockBasedPopulatorFactory() {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> {
            IndexDirectoryStructure directoryStructure = SimpleIndexDirectoryStructures.onIndexFile(storeFile);
            FileSystemIndexDropAction dropAction = new FileSystemIndexDropAction(fs, directoryStructure);
            return new GenericBlockBasedIndexPopulator(pageCache, fs, storeFile, layout, monitor, descriptor, spaceFillingCurveSettings, directoryStructure, (SpaceFillingCurveConfiguration)configuration, (IndexDropAction)dropAction, false, ByteBufferFactory.heapBufferFactory((int)10240));
        };
    }

    @FunctionalInterface
    public static interface PopulatorFactory<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        public NativeIndexPopulator<KEY, VALUE> create(PageCache var1, FileSystemAbstraction var2, File var3, IndexLayout<KEY, VALUE> var4, IndexProvider.Monitor var5, StoreIndexDescriptor var6) throws IOException;
    }

    static class TestCase<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        final String name;
        final PopulatorFactory<KEY, VALUE> populatorFactory;
        final ValueType[] typesOfGroup;
        final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;

        TestCase(String name, PopulatorFactory<KEY, VALUE> populatorFactory, ValueType[] typesOfGroup, IndexLayoutFactory<KEY, VALUE> indexLayoutFactory) {
            this.name = name;
            this.populatorFactory = populatorFactory;
            this.typesOfGroup = typesOfGroup;
            this.indexLayoutFactory = indexLayoutFactory;
        }

        public String toString() {
            return this.name;
        }
    }
}

