/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

public abstract class NativeIndexAccessorTests<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexTestUtil<KEY, VALUE> {
    private NativeIndexAccessor<KEY, VALUE> accessor;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void setupAccessor() throws IOException {
        this.accessor = this.makeAccessor();
    }

    abstract NativeIndexAccessor<KEY, VALUE> makeAccessor() throws IOException;

    abstract IndexCapability indexCapability();

    @After
    public void closeAccessor() {
        this.accessor.close();
    }

    @Test
    public void shouldHandleCloseWithoutCallsToProcess() throws Exception {
        NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
    }

    @Test
    public void processMustThrowAfterClose() throws Exception {
        NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
        this.expected.expect(IllegalStateException.class);
        updater.process(this.simpleUpdate());
    }

    @Test
    public void shouldIndexAdd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            this.processAll((IndexUpdater)updater, updates);
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexChange() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            Value newValue = ((IndexEntryUpdate)generator.next()).values()[0];
            updates[i] = IndexEntryUpdate.change((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value)update.values()[0], (Value)newValue);
        }
        this.processAll(updates);
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexRemove() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            IndexEntryUpdate remove = IndexEntryUpdate.remove((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])update.values());
            this.processAll(remove);
            this.forceAndCloseAccessor();
            this.verifyUpdates(Arrays.copyOfRange(updates, i + 1, updates.length));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldHandleRandomUpdates() throws Exception {
        HashSet<IndexEntryUpdate<IndexDescriptor>> expectedData = new HashSet<IndexEntryUpdate<IndexDescriptor>>();
        Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int rounds = 50;
        for (int round = 0; round < rounds; ++round) {
            IndexEntryUpdate<IndexDescriptor>[] batch = this.generateRandomUpdates(expectedData, newDataGenerator, this.random.nextInt(5, 20), (float)round / (float)rounds * 2.0f);
            this.processAll(batch);
            this.applyUpdatesToExpectedData(expectedData, batch);
            this.forceAndCloseAccessor();
            this.verifyUpdates(expectedData.toArray(new IndexEntryUpdate[0]));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldReturnZeroCountForEmptyIndex() {
        try (IndexReader reader = this.accessor.newReader();){
            IndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.randomUpdateGenerator(this.random).next();
            long count = reader.countIndexedNodes(123L, this.valueCreatorUtil.indexDescriptor.properties(), new Value[]{update.values()[0]});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountOneForExistingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                long count = reader.countIndexedNodes(update.getEntityId(), this.valueCreatorUtil.indexDescriptor.properties(), update.values());
                Assert.assertEquals((long)1L, (long)count);
            }
            Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
            long count = reader.countIndexedNodes(123L, this.valueCreatorUtil.indexDescriptor.properties(), new Value[]{((IndexEntryUpdate)generator.next()).values()[0]});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountZeroForMismatchingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            int[] propKeys = this.valueCreatorUtil.indexDescriptor.properties();
            long countWithMismatchingData = reader.countIndexedNodes(update.getEntityId() + 1L, propKeys, update.values());
            long countWithNonExistentEntityId = reader.countIndexedNodes(1000000000L, propKeys, update.values());
            long countWithNonExistentValue = reader.countIndexedNodes(update.getEntityId(), propKeys, new Value[]{this.generateUniqueValue(updates)});
            Assert.assertEquals((long)0L, (long)countWithMismatchingData);
            Assert.assertEquals((long)0L, (long)countWithNonExistentEntityId);
            Assert.assertEquals((long)0L, (long)countWithNonExistentValue);
        }
    }

    @Test
    public void shouldReturnAllEntriesForExistsPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, (IndexQuery)IndexQuery.exists((int)0));
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnNoEntriesForExistsPredicateForEmptyIndex() throws Exception {
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, (IndexQuery)IndexQuery.exists((int)0));
        long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void shouldReturnMatchingEntriesForExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            Value value = update.values()[0];
            LongIterator result = this.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));
            this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.in((Object[])new Value[]{value})), result);
        }
    }

    @Test
    public void shouldReturnNoEntriesForMismatchingExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        Value value = this.generateUniqueValue(updates);
        LongIterator result = this.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[updates.length - 1]), false));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOf(updates, updates.length - 1), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd(updates);
    }

    void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[updates.length - 1]), true));
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), false, this.valueOf(updates[updates.length - 1]), false));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length - 1), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), false, this.valueOf(updates[updates.length - 1]), true));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.valueCreatorUtil.sort(updates);
        this.processAll(updates[0], updates[1], updates[updates.length - 1], updates[updates.length - 2]);
        IndexReader reader = this.accessor.newReader();
        LongIterator result = this.query(reader, this.valueCreatorUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[updates.length - 3]), true));
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test(timeout=10000L)
    public void mustHandleNestedQueries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.mustHandleNestedQueries(updates);
    }

    void mustHandleNestedQueries(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery outerQuery = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[3]), true);
        IndexQuery innerQuery = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[1]), true);
        long[] expectedOuter = new long[]{this.entityIdOf(updates[2]), this.entityIdOf(updates[3])};
        long[] expectedInner = new long[]{this.entityIdOf(updates[0]), this.entityIdOf(updates[1])};
        LongIterator outerIter = this.query(reader, outerQuery);
        ArrayList<Long> outerResult = new ArrayList<Long>();
        while (outerIter.hasNext()) {
            outerResult.add(outerIter.next());
            LongIterator innerIter = this.query(reader, innerQuery);
            this.assertEntityIdHits(expectedInner, innerIter);
        }
        this.assertEntityIdHits(expectedOuter, outerResult);
    }

    @Test
    public void mustHandleMultipleNestedQueries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.mustHandleMultipleNestedQueries(updates);
    }

    void mustHandleMultipleNestedQueries(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery query1 = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[4]), true, this.valueOf(updates[5]), true);
        IndexQuery query2 = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[3]), true);
        IndexQuery query3 = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[1]), true);
        long[] expected1 = new long[]{this.entityIdOf(updates[4]), this.entityIdOf(updates[5])};
        long[] expected2 = new long[]{this.entityIdOf(updates[2]), this.entityIdOf(updates[3])};
        long[] expected3 = new long[]{this.entityIdOf(updates[0]), this.entityIdOf(updates[1])};
        ArrayList<Long> result1 = new ArrayList<Long>();
        LongIterator iter1 = this.query(reader, query1);
        while (iter1.hasNext()) {
            result1.add(iter1.next());
            ArrayList<Long> result2 = new ArrayList<Long>();
            LongIterator iter2 = this.query(reader, query2);
            while (iter2.hasNext()) {
                result2.add(iter2.next());
                ArrayList<Long> result3 = new ArrayList<Long>();
                LongIterator iter3 = this.query(reader, query3);
                while (iter3.hasNext()) {
                    result3.add(iter3.next());
                }
                this.assertEntityIdHits(expected3, result3);
            }
            this.assertEntityIdHits(expected2, result2);
        }
        this.assertEntityIdHits(expected1, result1);
    }

    private long entityIdOf(IndexEntryUpdate<IndexDescriptor> update) {
        return update.getEntityId();
    }

    @Test
    public void shouldHandleMultipleConsecutiveUpdaters() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates;
        for (IndexEntryUpdate<IndexDescriptor> update : updates = this.someUpdatesSingleType()) {
            try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void requestForSecondUpdaterMustThrow() throws Exception {
        try (NativeIndexUpdater ignored = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            this.expected.expect(IllegalStateException.class);
            this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        }
    }

    @Test
    public void dropShouldDeleteAndCloseIndex() {
        this.assertFilePresent();
        this.accessor.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void forceShouldCheckpointTree() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.force(IOLimiter.UNLIMITED);
        this.accessor.close();
        this.verifyUpdates(data);
    }

    @Test
    public void closeShouldCloseTreeWithoutCheckpoint() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.close();
        this.verifyUpdates(new IndexEntryUpdate[0]);
    }

    @Test
    public void snapshotFilesShouldReturnIndexFile() {
        ResourceIterator files = this.accessor.snapshotFiles();
        Assert.assertTrue((boolean)files.hasNext());
        Assert.assertEquals((Object)this.getIndexFile(), (Object)files.next());
        Assert.assertFalse((boolean)files.hasNext());
    }

    @Test
    public void shouldSampleIndex() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();
             IndexSampler sampler = reader.createSampler();){
            IndexSample sample = sampler.sampleIndex();
            Assert.assertEquals((long)updates.length, (long)sample.indexSize());
            Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
            Assert.assertEquals((long)ValueCreatorUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        }
    }

    @Test
    public void readingAfterDropShouldThrow() {
        this.accessor.drop();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newReader();
    }

    @Test
    public void writingAfterDropShouldThrow() {
        this.accessor.drop();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newUpdater(IndexUpdateMode.ONLINE);
    }

    @Test
    public void readingAfterCloseShouldThrow() {
        this.accessor.close();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newReader();
    }

    @Test
    public void writingAfterCloseShouldThrow() {
        this.accessor.close();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newUpdater(IndexUpdateMode.ONLINE);
    }

    @Test
    public void shouldSeeAllEntriesInAllEntriesReader() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Stream.of(updates).map(IndexEntryUpdate::getEntityId).collect(Collectors.toCollection(HashSet::new));
        Assert.assertEquals((Object)expectedIds, (Object)ids);
    }

    @Test
    public void shouldSeeNoEntriesInAllEntriesReaderOnEmptyIndex() {
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Collections.emptySet();
        Assert.assertEquals(expectedIds, (Object)ids);
    }

    @Test
    public void shouldNotSeeFilteredEntries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        NodeValueIterator iter = new NodeValueIterator();
        IndexQuery.ExactPredicate filter = IndexQuery.exact((int)0, (Object)this.valueOf(updates[1]));
        IndexQuery rangeQuery = this.valueCreatorUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[2]), true);
        IndexProgressor.NodeValueClient filterClient = this.filterClient(iter, (IndexQuery)filter);
        reader.query(filterClient, IndexOrder.NONE, false, new IndexQuery[]{rangeQuery});
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((long)this.entityIdOf(updates[1]), (long)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void respectIndexOrder() throws Exception {
        int nUpdates = 10000;
        ValueType[] types = this.supportedTypesExcludingNonOrderable();
        Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random, types);
        IndexEntryUpdate[] someUpdates = new IndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = this.valueCreatorUtil.extractValuesFromUpdates(someUpdates);
        try (IndexReader reader = this.accessor.newReader();){
            IndexOrder[] supportedOrders;
            ValueGroup valueGroup = ((Value)this.random.among(allValues)).valueGroup();
            IndexQuery.RangePredicate supportedQuery = IndexQuery.range((int)0, (ValueGroup)valueGroup);
            for (IndexOrder supportedOrder : supportedOrders = this.indexCapability().orderCapability(new ValueCategory[]{valueGroup.category()})) {
                if (supportedOrder == IndexOrder.NONE) continue;
                Value[] expectedValues = (Value[])Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).toArray(Value[]::new);
                if (supportedOrder == IndexOrder.ASCENDING) {
                    Arrays.sort(expectedValues, Values.COMPARATOR);
                }
                if (supportedOrder == IndexOrder.DESCENDING) {
                    Arrays.sort(expectedValues, Values.COMPARATOR.reversed());
                }
                SimpleNodeValueClient client = new SimpleNodeValueClient();
                reader.query((IndexProgressor.NodeValueClient)client, supportedOrder, true, new IndexQuery[]{supportedQuery});
                int i = 0;
                while (client.next()) {
                    Assert.assertEquals((String)"values in order", (Object)expectedValues[i++], (Object)client.values[0]);
                }
                Assert.assertEquals((String)"found all values", (long)i, (long)expectedValues.length);
            }
        }
    }

    @Test
    public void throwForUnsupportedIndexOrder() throws Exception {
        try (IndexReader reader = this.accessor.newReader();){
            IndexOrder unsupportedOrder = IndexOrder.DESCENDING;
            IndexQuery.ExactPredicate unsupportedQuery = IndexQuery.exact((int)0, (Object)PointValue.MAX_VALUE);
            this.expected.expect(UnsupportedOperationException.class);
            this.expected.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"unsupported order"), (Matcher)CoreMatchers.containsString((String)unsupportedOrder.toString()), (Matcher)CoreMatchers.containsString((String)unsupportedQuery.toString())));
            reader.query((IndexProgressor.NodeValueClient)new SimpleNodeValueClient(), unsupportedOrder, false, new IndexQuery[]{unsupportedQuery});
        }
    }

    @Test
    public void getValues() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        List expectedValues;
        IndexQuery.RangePredicate supportedQuery;
        int nUpdates = 10000;
        Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        IndexEntryUpdate[] someUpdates = new IndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = this.valueCreatorUtil.extractValuesFromUpdates(someUpdates);
        Value value = (Value)this.random.among(allValues);
        ValueGroup valueGroup = value.valueGroup();
        IndexValueCapability valueCapability = this.indexCapability().valueCapability(new ValueCategory[]{valueGroup.category()});
        if (!valueCapability.equals((Object)IndexValueCapability.YES)) {
            return;
        }
        if (Values.isGeometryValue((Value)value)) {
            CoordinateReferenceSystem crs = ((PointValue)value).getCoordinateReferenceSystem();
            supportedQuery = IndexQuery.range((int)0, (CoordinateReferenceSystem)crs);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == ValueGroup.GEOMETRY).filter(v -> ((PointValue)v).getCoordinateReferenceSystem() == crs).collect(Collectors.toList());
        } else {
            supportedQuery = IndexQuery.range((int)0, (ValueGroup)valueGroup);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).collect(Collectors.toList());
        }
        try (IndexReader reader = this.accessor.newReader();){
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            reader.query((IndexProgressor.NodeValueClient)client, IndexOrder.NONE, true, new IndexQuery[]{supportedQuery});
            while (client.next()) {
                Value foundValue = client.values[0];
                Assert.assertTrue((String)("found value that was not expected " + foundValue), (boolean)expectedValues.remove(foundValue));
            }
            Assert.assertThat((String)"did not find all expected values", (Object)expectedValues.size(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    private Value generateUniqueValue(IndexEntryUpdate<IndexDescriptor>[] updates) {
        return ((IndexEntryUpdate)Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random)).next()).values()[0];
    }

    private static Predicate<IndexEntryUpdate<IndexDescriptor>> skipExisting(IndexEntryUpdate<IndexDescriptor>[] existing) {
        return update -> {
            for (IndexEntryUpdate e : existing) {
                if (!Arrays.equals(e.values(), update.values())) continue;
                return false;
            }
            return true;
        };
    }

    private Value valueOf(IndexEntryUpdate<IndexDescriptor> update) {
        return update.values()[0];
    }

    private IndexProgressor.NodeValueClient filterClient(final NodeValueIterator iter, final IndexQuery filter) {
        return new IndexProgressor.NodeValueClient(){

            public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues) {
                iter.initialize(descriptor, progressor, query, indexOrder, needsValues);
            }

            public boolean acceptNode(long reference, Value ... values) {
                if (values.length > 1) {
                    return false;
                }
                return filter.acceptsValue(values[0]) && iter.acceptNode(reference, values);
            }

            public boolean needsValues() {
                return true;
            }
        };
    }

    private LongIterator query(IndexReader reader, IndexQuery query) throws IndexNotApplicableKernelException {
        NodeValueIterator client = new NodeValueIterator();
        reader.query((IndexProgressor.NodeValueClient)client, IndexOrder.NONE, false, new IndexQuery[]{query});
        return client;
    }

    private void assertEntityIdHits(long[] expected, LongIterator result) {
        long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
        this.assertSameContent(expected, actual);
    }

    private void assertEntityIdHits(long[] expected, Collection<Long> result) {
        long[] actual = new long[result.size()];
        int index = 0;
        for (Long aLong : result) {
            actual[index++] = aLong;
        }
        this.assertSameContent(expected, actual);
    }

    private void assertSameContent(long[] expected, long[] actual) {
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assert.assertArrayEquals((String)String.format("Expected arrays to be equal but wasn't.%nexpected:%s%n  actual:%s%n", Arrays.toString(expected), Arrays.toString(actual)), (long[])expected, (long[])actual);
    }

    private long[] extractEntityIds(IndexEntryUpdate<?>[] updates, Predicate<Value> valueFilter) {
        long[] entityIds = new long[updates.length];
        int cursor = 0;
        for (IndexEntryUpdate<?> update : updates) {
            if (!valueFilter.test(update.values()[0])) continue;
            entityIds[cursor++] = update.getEntityId();
        }
        return Arrays.copyOf(entityIds, cursor);
    }

    private void applyUpdatesToExpectedData(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, IndexEntryUpdate<IndexDescriptor>[] batch) {
        for (IndexEntryUpdate<IndexDescriptor> update : batch) {
            IndexEntryUpdate<IndexDescriptor> addition = null;
            IndexEntryUpdate<IndexDescriptor> removal = null;
            switch (update.updateMode()) {
                case ADDED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                case CHANGED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.beforeValues()[0]);
                    break;
                }
                case REMOVED: {
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(update.updateMode().name());
                }
            }
            if (removal != null) {
                expectedData.remove(removal);
            }
            if (addition == null) continue;
            expectedData.add(addition);
        }
    }

    private IndexEntryUpdate<IndexDescriptor>[] generateRandomUpdates(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator, int count, float removeFactor) {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        float addChangeRatio = 0.5f;
        for (int i = 0; i < count; ++i) {
            float factor = this.random.nextFloat();
            if (!expectedData.isEmpty() && factor < removeFactor) {
                IndexEntryUpdate<IndexDescriptor> toRemove = this.selectRandomItem(expectedData);
                updates[i] = IndexEntryUpdate.remove((long)toRemove.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toRemove.values());
                continue;
            }
            if (!expectedData.isEmpty() && factor < (1.0f - removeFactor) * addChangeRatio) {
                IndexEntryUpdate<IndexDescriptor> toChange = this.selectRandomItem(expectedData);
                IndexEntryUpdate<IndexDescriptor> updateContainingValue = newDataGenerator.next();
                updates[i] = IndexEntryUpdate.change((long)toChange.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toChange.values(), (Value[])updateContainingValue.values());
                continue;
            }
            updates[i] = newDataGenerator.next();
        }
        return updates;
    }

    private IndexEntryUpdate<IndexDescriptor> selectRandomItem(Set<IndexEntryUpdate<IndexDescriptor>> expectedData) {
        return expectedData.toArray(new IndexEntryUpdate[0])[this.random.nextInt(expectedData.size())];
    }

    @SafeVarargs
    private final void processAll(IndexEntryUpdate<IndexDescriptor> ... updates) throws IndexEntryConflictException {
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    private void forceAndCloseAccessor() {
        this.accessor.force(IOLimiter.UNLIMITED);
        this.closeAccessor();
    }

    private void processAll(IndexUpdater updater, IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException {
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
    }

    private IndexEntryUpdate<IndexDescriptor> simpleUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)});
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleType() {
        ValueType type = (ValueType)this.random.randomValues().among((Object[])this.valueCreatorUtil.supportedTypes());
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, true);
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates() {
        return this.someUpdatesSingleTypeNoDuplicates(this.valueCreatorUtil.supportedTypes());
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates(ValueType[] types) {
        ValueType type;
        while ((type = (ValueType)this.random.randomValues().among((Object[])types)) == ValueType.BOOLEAN) {
        }
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, false);
    }

    private ValueType[] supportedTypesExcludingNonOrderable() {
        return RandomValues.excluding((ValueType[])this.valueCreatorUtil.supportedTypes(), t -> t.valueGroup == ValueGroup.GEOMETRY || t.valueGroup == ValueGroup.GEOMETRY_ARRAY || t == ValueType.STRING || t == ValueType.STRING_ARRAY);
    }
}

