/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.index.DummyIndexImplementation;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.kernel.spi.explicitindex.IndexProviders;

public class DummyIndexExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String IDENTIFIER = "test-dummy-neo-index";
    static final String KEY_FAIL_ON_MUTATE = "fail_on_mutate";

    public DummyIndexExtensionFactory() {
        super(ExtensionType.DATABASE, IDENTIFIER);
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
        IndexProviders indexProviders = dependencies.getIndexProviders();
        return new Extension(indexProviders);
    }

    private static class Extension
    extends LifecycleAdapter {
        private final IndexProviders indexProviders;

        Extension(IndexProviders indexProviders) {
            this.indexProviders = indexProviders;
        }

        public void init() {
            this.indexProviders.registerIndexProvider(DummyIndexExtensionFactory.IDENTIFIER, (IndexImplementation)new DummyIndexImplementation());
        }

        public void shutdown() {
            this.indexProviders.unregisterIndexProvider(DummyIndexExtensionFactory.IDENTIFIER);
        }
    }

    public static interface Dependencies {
        public IndexProviders getIndexProviders();
    }
}

