/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

class TestMemoryAllocator
implements MemoryAllocator {
    final MemoryAllocationTracker tracker;

    TestMemoryAllocator() {
        this((MemoryAllocationTracker)new LocalMemoryTracker());
    }

    TestMemoryAllocator(MemoryAllocationTracker tracker) {
        this.tracker = tracker;
    }

    public Memory allocate(long size, boolean zeroed) {
        ByteBuffer buf = ByteBuffer.allocate(Math.toIntExact(size));
        if (zeroed) {
            Arrays.fill(buf.array(), (byte)0);
        }
        return new MemoryImpl(buf);
    }

    class MemoryImpl
    implements Memory {
        final ByteBuffer buf;

        MemoryImpl(ByteBuffer buf) {
            this.buf = buf;
            TestMemoryAllocator.this.tracker.allocated((long)buf.capacity());
        }

        public long readLong(long offset) {
            return this.buf.getLong(Math.toIntExact(offset));
        }

        public void writeLong(long offset, long value) {
            this.buf.putLong(Math.toIntExact(offset), value);
        }

        public void clear() {
            Arrays.fill(this.buf.array(), (byte)0);
        }

        public long size() {
            return this.buf.capacity();
        }

        public void free() {
            TestMemoryAllocator.this.tracker.deallocated((long)this.buf.capacity());
        }

        public Memory copy() {
            ByteBuffer copyBuf = ByteBuffer.wrap(Arrays.copyOf(this.buf.array(), this.buf.array().length));
            return new MemoryImpl(copyBuf);
        }

        public ByteBuffer asByteBuffer() {
            return this.buf;
        }
    }
}

