/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

public class IndexMapTest {
    private static final long[] noEntityToken = new long[0];
    private IndexMap indexMap;
    private LabelSchemaDescriptor schema3_4 = SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4});
    private LabelSchemaDescriptor schema5_6_7 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{6, 7});
    private LabelSchemaDescriptor schema5_8 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{8});
    private SchemaDescriptor node35_8 = SchemaDescriptorFactory.multiToken((int[])new int[]{3, 5}, (EntityType)EntityType.NODE, (int[])new int[]{8});
    private SchemaDescriptor rel35_8 = SchemaDescriptorFactory.multiToken((int[])new int[]{3, 5}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{8});

    @Before
    public void setup() {
        this.indexMap = new IndexMap();
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema3_4).withId(1L).withoutCapabilities()));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema5_6_7).withId(2L).withoutCapabilities()));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.schema5_8).withId(3L).withoutCapabilities()));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.node35_8).withId(4L).withoutCapabilities()));
        this.indexMap.putIndexProxy((IndexProxy)new TestIndexProxy(IndexDescriptorFactory.forSchema((SchemaDescriptor)this.rel35_8).withId(5L).withoutCapabilities()));
    }

    @Test
    public void shouldGetRelatedIndexForLabel() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
    }

    private Set<SchemaDescriptor> getRelatedIndexes(long[] changedEntityTokens, long[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete, EntityType type) {
        return this.indexMap.getRelatedIndexes(changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete, type).stream().map(SchemaDescriptorSupplier::schema).collect(Collectors.toSet());
    }

    @Test
    public void shouldGetRelatedIndexForProperty() {
        MatcherAssert.assertThat(this.getRelatedIndexes(noEntityToken, this.entityTokens(3L, 4L, 5L), this.properties(4), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4}));
    }

    @Test
    public void shouldGetRelatedIndexesForLabel() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(5L), this.entityTokens(3L, 4L), this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_6_7, this.schema5_8, this.node35_8}));
    }

    @Test
    public void shouldGetRelatedIndexes() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), this.entityTokens(4L, 5L), this.properties(7), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.schema5_6_7, this.node35_8}));
    }

    @Test
    public void shouldGetRelatedIndexOnce() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(4), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
        MatcherAssert.assertThat(this.getRelatedIndexes(noEntityToken, this.entityTokens(5L), this.properties(6, 7), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_6_7}));
    }

    @Test
    public void shouldHandleUnrelated() {
        MatcherAssert.assertThat(this.getRelatedIndexes(noEntityToken, noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.emptyIterableOf(SchemaDescriptor.class));
        Assert.assertTrue((boolean)this.getRelatedIndexes(this.entityTokens(2L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE).isEmpty());
        MatcherAssert.assertThat(this.getRelatedIndexes(noEntityToken, this.entityTokens(2L), this.properties(1), false, EntityType.NODE), (Matcher)Matchers.emptyIterableOf(SchemaDescriptor.class));
        Assert.assertTrue((boolean)this.getRelatedIndexes(this.entityTokens(2L), this.entityTokens(2L), this.properties(1), false, EntityType.NODE).isEmpty());
    }

    @Test
    public void shouldGetMultiLabelForAnyOfTheLabels() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4, this.node35_8}));
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(5L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_8, this.schema5_6_7, this.node35_8}));
    }

    @Test
    public void shouldOnlyGetRelIndexesForRelUpdates() {
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(new int[0]), false, EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(5L), noEntityToken, this.properties(new int[0]), false, EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
    }

    @Test
    public void removalsShouldOnlyRemoveCorrectProxy() {
        this.indexMap.removeIndexProxy(4L);
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema3_4}));
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(3L), noEntityToken, this.properties(new int[0]), false, EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
        this.indexMap.removeIndexProxy(7L);
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(5L), noEntityToken, this.properties(new int[0]), false, EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.schema5_8, this.schema5_6_7}));
        MatcherAssert.assertThat(this.getRelatedIndexes(this.entityTokens(5L), noEntityToken, this.properties(new int[0]), false, EntityType.RELATIONSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new SchemaDescriptor[]{this.rel35_8}));
    }

    @Test
    public void shouldGetRelatedNodeConstraints() {
        ConstraintRule constraint1 = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5, 6}), null);
        ConstraintRule constraint2 = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5}), null);
        ConstraintRule constraint3 = ConstraintRule.constraintRule((long)3L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{5}), null);
        this.indexMap.putUniquenessConstraint(constraint1);
        this.indexMap.putUniquenessConstraint(constraint2);
        this.indexMap.putUniquenessConstraint(constraint3);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint2.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(1L), this.entityTokens(new long[0]), this.properties(5), true, EntityType.NODE));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1.getConstraintDescriptor(), constraint2.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(1L), this.entityTokens(new long[0]), this.properties(5), false, EntityType.NODE));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1.getConstraintDescriptor(), constraint2.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(1L), this.entityTokens(new long[0]), this.properties(5, 6), true, EntityType.NODE));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1.getConstraintDescriptor(), constraint2.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(new long[0]), this.entityTokens(1L), this.properties(5), false, EntityType.NODE));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1.getConstraintDescriptor(), constraint2.getConstraintDescriptor(), constraint3.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(1L, 2L), this.entityTokens(new long[0]), this.properties(new int[0]), false, EntityType.NODE));
    }

    @Test
    public void shouldRemoveNodeConstraints() {
        ConstraintRule constraint1 = ConstraintRule.constraintRule((long)1L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5, 6}), null);
        ConstraintRule constraint2 = ConstraintRule.constraintRule((long)2L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5}), null);
        ConstraintRule constraint3 = ConstraintRule.constraintRule((long)3L, (ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{5}), null);
        this.indexMap.putUniquenessConstraint(constraint1);
        this.indexMap.putUniquenessConstraint(constraint2);
        this.indexMap.putUniquenessConstraint(constraint3);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint2.getConstraintDescriptor()}), (Object)this.indexMap.getRelatedConstraints(this.entityTokens(1L), this.entityTokens(new long[0]), this.properties(5), true, EntityType.NODE));
        this.indexMap.removeUniquenessConstraint(constraint1.getId());
        this.indexMap.removeUniquenessConstraint(constraint2.getId());
        this.indexMap.removeUniquenessConstraint(constraint3.getId());
        Assert.assertTrue((boolean)this.indexMap.getRelatedConstraints(this.entityTokens(1L), this.entityTokens(new long[0]), this.properties(5), true, EntityType.NODE).isEmpty());
    }

    private long[] entityTokens(long ... entityTokenIds) {
        return entityTokenIds;
    }

    private int[] properties(int ... propertyIds) {
        return propertyIds;
    }

    private class TestIndexProxy
    extends IndexProxyAdapter {
        private final CapableIndexDescriptor descriptor;

        private TestIndexProxy(CapableIndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public CapableIndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

