/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.Values;

public class BatchingMultipleIndexPopulatorTest {
    public static final int propertyId = 1;
    public static final int labelId = 1;
    private final IndexDescriptor index1 = TestIndexDescriptorFactory.forLabel(1, 1);
    private final IndexDescriptor index42 = TestIndexDescriptorFactory.forLabel(42, 42);

    @After
    public void tearDown() throws Exception {
        BatchingMultipleIndexPopulatorTest.clearProperty("queue_threshold");
        BatchingMultipleIndexPopulatorTest.clearProperty("task_queue_size");
        BatchingMultipleIndexPopulatorTest.clearProperty("await_timeout_minutes");
        BatchingMultipleIndexPopulatorTest.clearProperty("batch_size");
    }

    @Test
    public void populateFromQueueDoesNothingIfThresholdNotReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 5);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)Mockito.mock(IndexStoreView.class), BatchingMultipleIndexPopulatorTest.immediateExecutor(), (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any())).thenReturn((Object)updater);
        IndexEntryUpdate<SchemaDescriptor> update1 = IndexQueryHelper.add(1L, this.index1.schema(), "foo");
        IndexEntryUpdate<SchemaDescriptor> update2 = IndexQueryHelper.add(2L, this.index1.schema(), "bar");
        batchingPopulator.queueUpdate(update1);
        batchingPopulator.queueUpdate(update2);
        batchingPopulator.populateFromQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any());
    }

    @Test
    public void populateFromQueuePopulatesWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 2);
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)storeView, BatchingMultipleIndexPopulatorTest.immediateExecutor(), (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator1.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any())).thenReturn((Object)updater1);
        IndexPopulator populator2 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator2.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any())).thenReturn((Object)updater2);
        batchingPopulator.indexAllEntities();
        IndexEntryUpdate<SchemaDescriptor> update1 = IndexQueryHelper.add(1L, this.index1.schema(), "foo");
        IndexEntryUpdate<SchemaDescriptor> update2 = IndexQueryHelper.add(2L, this.index42.schema(), "bar");
        IndexEntryUpdate<SchemaDescriptor> update3 = IndexQueryHelper.add(3L, this.index1.schema(), "baz");
        batchingPopulator.queueUpdate(update1);
        batchingPopulator.queueUpdate(update2);
        batchingPopulator.queueUpdate(update3);
        batchingPopulator.populateFromQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update3);
        ((IndexUpdater)Mockito.verify((Object)updater2)).process(update2);
    }

    @Test
    public void executorShutdownAfterStoreScanCompletes() throws Exception {
        EntityUpdates update = this.nodeUpdates(1, 1, "foo", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        StoreScan storeScan = batchingPopulator.indexAllEntities();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        storeScan.run();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        batchingPopulator.close(true);
        ((ExecutorService)Mockito.verify((Object)executor)).shutdown();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void executorForcefullyShutdownIfStoreScanFails() throws Exception {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        StoreScan failingStoreScan = (StoreScan)Mockito.mock(StoreScan.class);
        RuntimeException scanError = new RuntimeException();
        ((StoreScan)Mockito.doThrow((Throwable[])new Throwable[]{scanError}).when((Object)failingStoreScan)).run();
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)failingStoreScan);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        StoreScan storeScan = batchingPopulator.indexAllEntities();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        try {
            storeScan.run();
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertSame((Object)scanError, (Object)t);
        }
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdownNow();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        batchingPopulator.close(false);
        ((ExecutorService)Mockito.verify((Object)executor)).shutdownNow();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void pendingBatchesFlushedAfterStoreScan() throws Exception {
        EntityUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        EntityUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        EntityUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        EntityUpdates update42 = this.nodeUpdates(4, 42, "42", 42L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update42);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexPopulator populator42 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        batchingPopulator.indexAllEntities().run();
        ((IndexPopulator)Mockito.verify((Object)populator1)).add(this.forUpdates(this.index1, update1, update2, update3));
        ((IndexPopulator)Mockito.verify((Object)populator42)).add(this.forUpdates(this.index42, update42));
    }

    @Test
    public void batchIsFlushedWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        EntityUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        EntityUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.indexAllEntities().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populatorMarkedAsFailed() throws Exception {
        IndexPopulator populator;
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        EntityUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
            populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
            List<IndexEntryUpdate<IndexDescriptor>> expected = this.forUpdates(this.index1, update1, update2);
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{batchFlushError}).when((Object)populator)).add(expected);
            batchingPopulator.indexAllEntities().run();
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
    }

    @Test
    public void populatorMarkedAsFailedAndUpdatesNotAdded() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        EntityUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        EntityUpdates update3 = this.nodeUpdates(1, 1, "ccc", 1L);
        EntityUpdates update4 = this.nodeUpdates(1, 1, "ddd", 1L);
        EntityUpdates update5 = this.nodeUpdates(1, 1, "eee", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update4, update5);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{batchFlushError}).when((Object)populator)).add(this.forUpdates(this.index1, update3, update4));
        batchingPopulator.indexAllEntities().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3, update4));
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).add(this.forUpdates(this.index1, update5));
    }

    @Test
    public void shouldApplyBatchesInParallel() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates[] updates = new EntityUpdates[9];
        for (int i = 0; i < updates.length; ++i) {
            updates[i] = this.nodeUpdates(i, 1, String.valueOf(i), 1L);
        }
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(updates);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.sameThreadExecutor();
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance(), (SchemaState)Mockito.mock(SchemaState.class));
        BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.indexAllEntities().run();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.atLeast((int)5))).execute((Runnable)ArgumentMatchers.any(Runnable.class));
    }

    private List<IndexEntryUpdate<IndexDescriptor>> forUpdates(IndexDescriptor index, EntityUpdates ... updates) {
        return Iterables.asList((Iterable)Iterables.concat((Iterable)Iterables.map(update -> update.forIndexKeys(Iterables.asIterable((Object[])new IndexDescriptor[]{index})), Arrays.asList(updates))));
    }

    private EntityUpdates nodeUpdates(int nodeId, int propertyId, String propertyValue, long ... labelIds) {
        return EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(labelIds).withTokensAfter(labelIds).added(propertyId, Values.of((Object)propertyValue)).build();
    }

    private static IndexPopulator addPopulator(BatchingMultipleIndexPopulator batchingPopulator, IndexDescriptor descriptor) {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        batchingPopulator.addPopulator(populator, descriptor.withId(1L).withoutCapabilities(), flipper, failedIndexProxyFactory, "testIndex");
        return populator;
    }

    private static IndexStoreView newStoreView(EntityUpdates ... updates) {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> {
            Visitor visitorArg = (Visitor)invocation.getArgument(2);
            return new IndexEntryUpdateScan(updates, (Visitor<EntityUpdates, IndexPopulationFailedKernelException>)visitorArg);
        });
        return storeView;
    }

    private static ExecutorService sameThreadExecutor() throws InterruptedException {
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)true);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0)).run();
            return null;
        }).when((Object)executor)).execute((Runnable)ArgumentMatchers.any());
        return executor;
    }

    private static void setProperty(String name, int value) {
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)name, (Object)value);
    }

    private static void clearProperty(String name) {
        FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)name);
    }

    private static ExecutorService immediateExecutor() {
        ExecutorService result = (ExecutorService)Mockito.mock(ExecutorService.class);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0)).run();
            return null;
        }).when((Object)result)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        return result;
    }

    private static class IndexEntryUpdateScan
    implements StoreScan<IndexPopulationFailedKernelException> {
        final EntityUpdates[] updates;
        final Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor;
        boolean stop;

        IndexEntryUpdateScan(EntityUpdates[] updates, Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor) {
            this.updates = updates;
            this.visitor = visitor;
        }

        public void run() throws IndexPopulationFailedKernelException {
            for (EntityUpdates update : this.updates) {
                if (this.stop) {
                    return;
                }
                this.visitor.visit((Object)update);
            }
        }

        public void stop() {
            this.stop = true;
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }
    }
}

