/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.LockTracer;

public class StatementLifecycleTest {
    @Test
    public void shouldReleaseStoreStatementOnlyWhenReferenceCountDownToZero() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        KernelStatement statement = this.getKernelStatement(transaction, storageReader);
        statement.acquire();
        ((StorageReader)Mockito.verify((Object)storageReader)).acquire();
        statement.acquire();
        statement.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{storageReader});
        statement.close();
        ((StorageReader)Mockito.verify((Object)storageReader)).release();
    }

    @Test
    public void shouldReleaseStoreStatementWhenForceClosingStatements() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        KernelStatement statement = this.getKernelStatement(transaction, storageReader);
        statement.acquire();
        try {
            statement.forceClose();
        }
        catch (KernelStatement.StatementNotClosedException statementNotClosedException) {
            // empty catch block
        }
        ((StorageReader)Mockito.verify((Object)storageReader)).release();
    }

    private KernelStatement getKernelStatement(KernelTransactionImplementation transaction, StorageReader storageReader) {
        return new KernelStatement(transaction, null, storageReader, LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), new ClockContext(), EmptyVersionContextSupplier.EMPTY);
    }
}

