/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSetsImpl;

public class MutableDiffSetsImplTest {
    private static final Predicate<Long> ODD_FILTER = item -> item % 2L != 0L;
    private final MutableDiffSetsImpl<Long> diffSets = new MutableDiffSetsImpl();

    @Test
    public void testAdd() {
        this.diffSets.add((Object)1L);
        this.diffSets.add((Object)2L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)this.diffSets.getAdded());
        Assert.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    public void testRemove() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)2L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)this.diffSets.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)this.diffSets.getRemoved());
    }

    @Test
    public void testAddRemove() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)1L);
        Assert.assertTrue((boolean)this.diffSets.getAdded().isEmpty());
        Assert.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    public void testRemoveAdd() {
        this.diffSets.remove((Object)1L);
        this.diffSets.add((Object)1L);
        Assert.assertTrue((boolean)this.diffSets.getAdded().isEmpty());
        Assert.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    public void testIsAddedOrRemoved() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)10L);
        Assert.assertTrue((boolean)this.diffSets.isAdded((Object)1L));
        Assert.assertTrue((!this.diffSets.isAdded((Object)2L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.diffSets.isRemoved((Object)10L));
        Assert.assertTrue((!this.diffSets.isRemoved((Object)2L) ? 1 : 0) != 0);
    }

    @Test
    public void testAddRemoveAll() {
        this.diffSets.addAll(Iterators.iterator((Object[])new Long[]{1L, 2L}));
        this.diffSets.removeAll(Iterators.iterator((Object[])new Long[]{2L, 3L}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)this.diffSets.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L}), (Object)this.diffSets.getRemoved());
    }

    @Test
    public void testFilterAdded() {
        this.diffSets.addAll(Iterators.iterator((Object[])new Long[]{1L, 2L}));
        this.diffSets.removeAll(Iterators.iterator((Object[])new Long[]{3L, 4L}));
        MutableDiffSetsImpl filtered = this.diffSets.filterAdded(ODD_FILTER);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)filtered.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L, 4L}), (Object)filtered.getRemoved());
    }

    @Test
    public void testReturnSourceFromApplyWithEmptyDiffSets() {
        Iterator result = this.diffSets.apply(Collections.singletonList(18L).iterator());
        Assert.assertEquals(Collections.singletonList(18L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testAppendAddedToSourceInApply() {
        this.diffSets.add((Object)52L);
        this.diffSets.remove((Object)43L);
        Iterator result = this.diffSets.apply(Collections.singletonList(18L).iterator());
        Assert.assertEquals(Arrays.asList(18L, 52L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testFilterRemovedFromSourceInApply() {
        this.diffSets.remove((Object)43L);
        Iterator result = this.diffSets.apply(Arrays.asList(42L, 43L, 44L).iterator());
        Assert.assertEquals(Arrays.asList(42L, 44L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testFilterAddedFromSourceInApply() {
        this.diffSets.add((Object)42L);
        this.diffSets.add((Object)44L);
        Iterator result = this.diffSets.apply(Arrays.asList(42L, 43L).iterator());
        Collection collectedResult = Iterators.asCollection((Iterator)result);
        Assert.assertEquals((long)3L, (long)collectedResult.size());
        MatcherAssert.assertThat((Object)collectedResult, (Matcher)IsCollectionContaining.hasItems((Object[])new Long[]{43L, 42L, 44L}));
    }
}

