/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;

public class KernelTransactionSecurityContextTest
extends KernelTransactionTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldNotAllowReadsInNoneMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.none());
        this.exception.expect(AuthorizationViolationException.class);
        tx.dataRead();
    }

    @Test
    public void shouldNotAllowTokenReadsInNoneMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.none());
        this.exception.expect(AuthorizationViolationException.class);
        tx.tokenRead();
    }

    @Test
    public void shouldNotAllowWritesInNoneMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.none());
        this.exception.expect(AuthorizationViolationException.class);
        tx.dataWrite();
    }

    @Test
    public void shouldNotAllowSchemaWritesInNoneMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.none());
        this.exception.expect(AuthorizationViolationException.class);
        tx.schemaWrite();
    }

    @Test
    public void shouldAllowReadsInReadMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        Read reads = tx.dataRead();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldNotAllowWriteAccessInReadMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        this.exception.expect(AuthorizationViolationException.class);
        tx.dataWrite();
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInReadMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        this.exception.expect(AuthorizationViolationException.class);
        tx.schemaWrite();
    }

    @Test
    public void shouldNotAllowReadAccessInWriteOnlyMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        this.exception.expect(AuthorizationViolationException.class);
        tx.dataRead();
    }

    @Test
    public void shouldNotAllowTokenReadAccessInWriteOnlyMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        this.exception.expect(AuthorizationViolationException.class);
        tx.tokenRead();
    }

    @Test
    public void shouldAllowWriteAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        Write writes = tx.dataWrite();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        this.exception.expect(AuthorizationViolationException.class);
        tx.schemaWrite();
    }

    @Test
    public void shouldAllowReadsInWriteMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        Read reads = tx.dataRead();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldAllowWritesInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        Write writes = tx.dataWrite();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        this.exception.expect(AuthorizationViolationException.class);
        tx.schemaWrite();
    }

    @Test
    public void shouldAllowReadsInFullMode() {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        Read reads = tx.dataRead();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldAllowWritesInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        Write writes = tx.dataWrite();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldAllowSchemaWriteAccessInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        SchemaWrite writes = tx.schemaWrite();
        Assert.assertNotNull((Object)writes);
    }
}

