/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.DefaultExplicitIndexProvider;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;

class DefaultExplicitIndexProviderTest {
    private final DefaultExplicitIndexProvider provider = new DefaultExplicitIndexProvider();

    DefaultExplicitIndexProviderTest() {
    }

    @Test
    void registerAndAccessIndexProvider() {
        IndexImplementation index = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        String testProviderName = "a";
        this.provider.registerIndexProvider(testProviderName, index);
        Assertions.assertSame((Object)index, (Object)this.provider.getProviderByName(testProviderName));
    }

    @Test
    void throwOnAttemptToRegisterProviderWithSameName() {
        IndexImplementation index = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        String testProviderName = "a";
        this.provider.registerIndexProvider(testProviderName, index);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.provider.registerIndexProvider(testProviderName, index));
    }

    @Test
    void unregisterIndexProvider() {
        IndexImplementation index = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        String testProviderName = "b";
        this.provider.registerIndexProvider(testProviderName, index);
        Assertions.assertTrue((boolean)this.provider.unregisterIndexProvider(testProviderName));
    }

    @Test
    void removeNotExistentProvider() {
        Assertions.assertFalse((boolean)this.provider.unregisterIndexProvider("c"));
    }

    @Test
    void throwOnAttemptToGetNonRegisteredProviderByName() {
        String testProviderName = "d";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.provider.getProviderByName(testProviderName));
    }

    @Test
    void accessAllRegisteredIndexProviders() {
        IndexImplementation index1 = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        IndexImplementation index2 = (IndexImplementation)Mockito.mock(IndexImplementation.class);
        String testProviderName1 = "e";
        String testProviderName2 = "f";
        this.provider.registerIndexProvider(testProviderName1, index1);
        this.provider.registerIndexProvider(testProviderName2, index2);
        MatcherAssert.assertThat((Object)this.provider.allIndexProviders(), (Matcher)Matchers.contains((Object[])new IndexImplementation[]{index1, index2}));
    }
}

