/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;

public class SchemaDescriptorFactoryTest {
    private static final int REL_TYPE_ID = 0;
    private static final int LABEL_ID = 0;

    @Test
    public void shouldCreateLabelDescriptors() {
        LabelSchemaDescriptor labelDesc = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)labelDesc.getLabelId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1);
        labelDesc = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)labelDesc.getLabelId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1, 2, 3);
        labelDesc = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[0]);
        MatcherAssert.assertThat((Object)labelDesc.getLabelId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), new int[0]);
    }

    @Test
    public void shouldCreateRelTypeDescriptors() {
        RelationTypeSchemaDescriptor relTypeDesc = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)relTypeDesc.getRelTypeId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1);
        relTypeDesc = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)relTypeDesc.getRelTypeId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1, 2, 3);
        relTypeDesc = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[0]);
        MatcherAssert.assertThat((Object)relTypeDesc.getRelTypeId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), new int[0]);
    }

    @Test
    public void shouldCreateEqualLabels() {
        LabelSchemaDescriptor desc1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor desc2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldCreateEqualRelTypes() {
        RelationTypeSchemaDescriptor desc1 = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1});
        RelationTypeSchemaDescriptor desc2 = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)":Label1(property2)"));
        MatcherAssert.assertThat((Object)SchemaDescriptorFactory.forRelType((int)1, (int[])new int[]{3}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"-[:RelType1(property3)]-"));
    }
}

