/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.BarService;
import org.neo4j.helpers.BazService;
import org.neo4j.helpers.FooService;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;

class ServiceTest {
    private ClassLoader contextClassLoader;

    ServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @AfterEach
    void tearDown() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
    }

    @Test
    void shouldLoadServiceInDefaultEnvironment() {
        FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
        Assertions.assertTrue((boolean)(fooService instanceof BarService));
    }

    @Test
    void whenContextCallsLoaderBlocksServicesFolderShouldLoadClassFromKernelClassloader() {
        Thread.currentThread().setContextClassLoader(new ServiceBlockClassLoader(this.contextClassLoader));
        FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
        Assertions.assertTrue((boolean)(fooService instanceof BarService));
    }

    @Test
    void whenContextClassLoaderOverridesServiceShouldLoadThatClass() {
        Thread.currentThread().setContextClassLoader(new ServiceRedirectClassLoader(this.contextClassLoader));
        FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
        Assertions.assertTrue((boolean)(fooService instanceof BazService));
    }

    @Test
    void whenContextClassLoaderDuplicatesServiceShouldLoadItOnce() {
        Thread.currentThread().setContextClassLoader(Service.class.getClassLoader());
        Iterable services = Service.load(FooService.class);
        Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)services));
    }

    private static final class ServiceRedirectClassLoader
    extends ClassLoader {
        ServiceRedirectClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public URL getResource(String name) {
            return name.startsWith("META-INF/services") ? super.getResource("test/" + name) : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return name.startsWith("META-INF/services") ? super.getResources("test/" + name) : super.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return name.startsWith("META-INF/services") ? super.getResourceAsStream("test/" + name) : super.getResourceAsStream(name);
        }
    }

    private static final class ServiceBlockClassLoader
    extends ClassLoader {
        ServiceBlockClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public URL getResource(String name) {
            return name.startsWith("META-INF/services") ? null : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return name.startsWith("META-INF/services") ? Collections.enumeration(Collections.emptySet()) : super.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return name.startsWith("META-INF/services") ? null : super.getResourceAsStream(name);
        }
    }
}

