/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;

public class Configuration
extends ExternalResource {
    public static final String DEFAULT = null;
    private final Map<String, String> configuration = new HashMap<String, String>();
    private final Map<String, String> sysProperties = new HashMap<String, String>();

    public Config config(LoadableConfig settingsClasses) {
        return Config.builder().withSettings(this.configuration).withConfigClasses(Collections.singletonList(settingsClasses)).build();
    }

    public Configuration with(Setting<?> setting, String value) {
        String key = setting.name();
        if (value == null) {
            this.configuration.remove(key);
        } else {
            this.configuration.put(key, value);
        }
        return this;
    }

    public Configuration withSystemProperty(String key, String value) {
        if ((value = this.sysProperties.put(key, Configuration.updateSystemProperty(key, value))) != null) {
            this.sysProperties.remove(key);
            Configuration.updateSystemProperty(key, value);
            throw new IllegalArgumentException("Cannot update '" + key + "' more than once.");
        }
        return this;
    }

    protected void after() {
        for (Map.Entry<String, String> entry : this.sysProperties.entrySet()) {
            Configuration.updateSystemProperty(entry.getKey(), entry.getValue());
        }
    }

    private static String updateSystemProperty(String key, String value) {
        if (value == null) {
            return System.clearProperty(key);
        }
        return System.setProperty(key, value);
    }
}

