/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class SynchronizedArrayIdOrderingQueue
implements IdOrderingQueue {
    private long[] queue;
    private int offerIndex;
    private int headIndex;

    public SynchronizedArrayIdOrderingQueue(int initialMaxSize) {
        this.queue = new long[initialMaxSize];
    }

    @Override
    public synchronized void offer(long value) {
        if (this.offerIndex - this.headIndex >= this.queue.length) {
            this.extendArray();
        }
        assert (this.offerIndex == this.headIndex || (long)((this.offerIndex - 1) % this.queue.length) < value) : "Was offered ids out-of-order, " + value + " whereas last offered was " + (this.offerIndex - 1) % this.queue.length;
        this.queue[this.offerIndex++ % this.queue.length] = value;
    }

    @Override
    public synchronized void waitFor(long value) throws InterruptedException {
        while (this.offerIndex == this.headIndex || this.queue[this.headIndex % this.queue.length] != value) {
            this.wait();
        }
    }

    @Override
    public synchronized void removeChecked(long expectedValue) {
        if (this.queue[this.headIndex % this.queue.length] != expectedValue) {
            throw new IllegalStateException("Was about to remove head and expected it to be " + expectedValue + ", but it was " + this.queue[this.headIndex]);
        }
        ++this.headIndex;
        this.notifyAll();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.offerIndex == this.headIndex;
    }

    private void extendArray() {
        long[] newQueue = new long[this.queue.length << 1];
        int length = this.offerIndex - this.headIndex;
        for (int i = 0; i < length; ++i) {
            newQueue[i] = this.queue[(this.headIndex + i) % this.queue.length];
        }
        this.queue = newQueue;
        this.offerIndex = length;
        this.headIndex = 0;
    }
}

