/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Objects;
import org.neo4j.storageengine.api.lock.ResourceType;

public interface ActiveLock {
    public static final String SHARED_MODE = "SHARED";
    public static final String EXCLUSIVE_MODE = "EXCLUSIVE";

    public String mode();

    public ResourceType resourceType();

    public long resourceId();

    public static ActiveLock exclusiveLock(ResourceType resourceType, long resourceId) {
        return new Implementation(resourceType, resourceId){

            @Override
            public String mode() {
                return ActiveLock.EXCLUSIVE_MODE;
            }
        };
    }

    public static ActiveLock sharedLock(ResourceType resourceType, long resourceId) {
        return new Implementation(resourceType, resourceId){

            @Override
            public String mode() {
                return ActiveLock.SHARED_MODE;
            }
        };
    }

    public static abstract class Implementation
    implements ActiveLock {
        private final ResourceType resourceType;
        private final long resourceId;

        private Implementation(ResourceType resourceType, long resourceId) {
            this.resourceType = resourceType;
            this.resourceId = resourceId;
        }

        @Override
        public abstract String mode();

        @Override
        public ResourceType resourceType() {
            return this.resourceType;
        }

        @Override
        public long resourceId() {
            return this.resourceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ActiveLock)) {
                return false;
            }
            ActiveLock that = (ActiveLock)o;
            return this.resourceId == that.resourceId() && Objects.equals(this.mode(), that.mode()) && Objects.equals(this.resourceType, that.resourceType());
        }

        public int hashCode() {
            return Objects.hash(this.resourceType, this.resourceId, this.mode());
        }
    }

    public static interface Factory {
        public static final Factory SHARED_LOCK = ActiveLock::sharedLock;
        public static final Factory EXCLUSIVE_LOCK = ActiveLock::exclusiveLock;

        public ActiveLock create(ResourceType var1, long var2);
    }
}

