/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.LocalTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;

class LocalTimeLayout
extends SchemaLayout<LocalTimeSchemaKey> {
    LocalTimeLayout() {
        super("Tlt", 0, 1);
    }

    public LocalTimeSchemaKey newKey() {
        return new LocalTimeSchemaKey();
    }

    public LocalTimeSchemaKey copyKey(LocalTimeSchemaKey key, LocalTimeSchemaKey into) {
        into.nanoOfDay = key.nanoOfDay;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(LocalTimeSchemaKey key) {
        return 16;
    }

    public void writeKey(PageCursor cursor, LocalTimeSchemaKey key) {
        cursor.putLong(key.nanoOfDay);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, LocalTimeSchemaKey into, int keySize) {
        into.nanoOfDay = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

