/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Cancelable;
import org.neo4j.helpers.TaskControl;

public class TaskCoordinator
implements Cancelable,
Factory<TaskControl> {
    private static final AtomicIntegerFieldUpdater<TaskCoordinator> TASKS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TaskCoordinator.class, "tasks");
    private volatile boolean cancelled;
    private volatile int tasks;
    private final long sleepTime;
    private final TimeUnit sleepUnit;

    public TaskCoordinator(long sleepTime, TimeUnit sleepUnit) {
        this.sleepTime = sleepTime;
        this.sleepUnit = sleepUnit;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void awaitCompletion() throws InterruptedException {
        while (this.tasks != 0) {
            this.sleepUnit.sleep(this.sleepTime);
        }
    }

    public TaskControl newInstance() {
        if (this.cancelled) {
            throw new IllegalStateException("This manager has already been cancelled.");
        }
        TASKS_UPDATER.incrementAndGet(this);
        return new TaskControl(){
            private volatile boolean closed;

            @Override
            public void close() {
                if (!this.closed) {
                    this.closed = true;
                    TASKS_UPDATER.decrementAndGet(TaskCoordinator.this);
                }
            }

            @Override
            public boolean cancellationRequested() {
                return TaskCoordinator.this.cancelled;
            }
        };
    }
}

