/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.DataGeneratorInput;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.HumanUnderstandableExecutionMonitor;

public class HumanUnderstandableExecutionMonitorIT {
    private static final long NODE_COUNT = 1000L;
    private static final long RELATIONSHIP_COUNT = 10000L;
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldReportProgressOfNodeImport() throws Exception {
        CapturingMonitor progress = new CapturingMonitor();
        HumanUnderstandableExecutionMonitor monitor = new HumanUnderstandableExecutionMonitor((HumanUnderstandableExecutionMonitor.Monitor)progress, HumanUnderstandableExecutionMonitor.NO_EXTERNAL_MONITOR);
        IdType idType = IdType.INTEGER;
        DataGeneratorInput input = new DataGeneratorInput(1000L, 10000L, idType, Collector.EMPTY, this.random.seed(), 0L, DataGeneratorInput.bareboneNodeHeader(idType, new Extractors(';')), DataGeneratorInput.bareboneRelationshipHeader(idType, new Extractors(';'), new Header.Entry[0]), 1, 1, 0.0f, 0.0f);
        new ParallelBatchImporter(this.storage.directory().absolutePath(), this.storage.fileSystem(), this.storage.pageCache(), Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (ExecutionMonitor)monitor, AdditionalInitialIds.EMPTY, Config.defaults(), Standard.LATEST_RECORD_FORMATS, ImportLogic.NO_MONITOR).doImport((Input)input);
        progress.assertAllProgressReachedEnd();
    }

    private static class CapturingMonitor
    implements HumanUnderstandableExecutionMonitor.Monitor {
        final EnumMap<HumanUnderstandableExecutionMonitor.ImportStage, AtomicInteger> progress = new EnumMap(HumanUnderstandableExecutionMonitor.ImportStage.class);

        private CapturingMonitor() {
        }

        public void progress(HumanUnderstandableExecutionMonitor.ImportStage stage, int percent) {
            AtomicInteger stageProgress;
            int previous;
            if (percent > 100) {
                Assert.fail((String)("Expected percentage to be 0..100% but was " + percent));
            }
            if ((previous = (stageProgress = this.progress.computeIfAbsent(stage, s -> new AtomicInteger())).getAndSet(percent)) > percent) {
                Assert.fail((String)("Progress should go forwards only, but went from " + previous + " to " + percent));
            }
        }

        void assertAllProgressReachedEnd() {
            Assert.assertEquals((long)HumanUnderstandableExecutionMonitor.ImportStage.values().length, (long)this.progress.size());
            this.progress.values().forEach(p -> Assert.assertEquals((long)100L, (long)p.get()));
        }
    }
}

