/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.List;
import java.util.Random;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.Randoms;
import org.neo4j.unsafe.impl.batchimport.GeneratingInputIterator;
import org.neo4j.unsafe.impl.batchimport.RandomsStates;
import org.neo4j.unsafe.impl.batchimport.input.Distribution;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class RandomEntityDataGenerator
extends GeneratingInputIterator<Randoms> {
    public RandomEntityDataGenerator(long nodeCount, long count, int batchSize, long seed, long startId, Header header, Distribution<String> labels, Distribution<String> relationshipTypes, float factorBadNodeData, float factorBadRelationshipData) {
        super(count, batchSize, new RandomsStates(seed), (randoms, visitor, id) -> {
            block7: for (Header.Entry entry : header.entries()) {
                switch (entry.type()) {
                    case ID: {
                        if (factorBadNodeData > 0.0f && id > 0L && randoms.nextFloat() <= factorBadNodeData) {
                            id = randoms.nextLong(id);
                        }
                        visitor.id(RandomEntityDataGenerator.idValue(entry, id), entry.group());
                        if (entry.name() == null) continue block7;
                        visitor.property(entry.name(), (Object)id);
                        continue block7;
                    }
                    case PROPERTY: {
                        visitor.property(entry.name(), RandomEntityDataGenerator.randomProperty(entry, randoms));
                        continue block7;
                    }
                    case LABEL: {
                        visitor.labels(RandomEntityDataGenerator.randomLabels(randoms.random(), labels));
                        continue block7;
                    }
                    case START_ID: 
                    case END_ID: {
                        long nodeId = randoms.nextLong(nodeCount);
                        if (factorBadRelationshipData > 0.0f && nodeId > 0L && randoms.nextFloat() <= factorBadRelationshipData) {
                            if (randoms.nextBoolean()) continue block7;
                            nodeId = randoms.nextLong();
                        }
                        if (entry.type() == Type.START_ID) {
                            visitor.startId(RandomEntityDataGenerator.idValue(entry, nodeId), entry.group());
                            continue block7;
                        }
                        visitor.endId(RandomEntityDataGenerator.idValue(entry, nodeId), entry.group());
                        continue block7;
                    }
                    case TYPE: {
                        visitor.type(RandomEntityDataGenerator.randomRelationshipType(randoms.random(), relationshipTypes));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException(entry.toString());
                    }
                }
            }
        }, startId);
    }

    private static Object idValue(Header.Entry entry, long id) {
        switch (entry.extractor().name()) {
            case "String": {
                return "" + id;
            }
            case "long": {
                return id;
            }
        }
        throw new IllegalArgumentException(entry.name());
    }

    private static String randomRelationshipType(Random random, Distribution<String> relationshipTypes) {
        return relationshipTypes.random(random);
    }

    private static Object randomProperty(Header.Entry entry, Randoms random) {
        String type = entry.extractor().name();
        if (type.equals("String")) {
            return random.string(5, 20, 3);
        }
        if (type.equals("long")) {
            return random.nextInt(Integer.MAX_VALUE);
        }
        if (type.equals("int")) {
            return random.nextInt(20);
        }
        throw new IllegalArgumentException("" + entry);
    }

    private static String[] randomLabels(Random random, Distribution<String> labels) {
        int length = random.nextInt(Integer.min(3, labels.length()));
        if (length == 0) {
            return InputEntity.NO_LABELS;
        }
        Object[] result = new String[length];
        int i = 0;
        while (i < result.length) {
            String candidate = labels.random(random);
            if (ArrayUtil.contains((Object[])result, (int)i, (Object)candidate)) continue;
            result[i++] = candidate;
        }
        return result;
    }

    public static <T> T convert(InputEntity entity, Deserialization<T> deserialization, Header header) {
        deserialization.clear();
        block8: for (Header.Entry entry : header.entries()) {
            switch (entry.type()) {
                case ID: {
                    deserialization.handle(entry, entity.hasLongId ? Long.valueOf(entity.longId) : entity.objectId);
                    continue block8;
                }
                case PROPERTY: {
                    deserialization.handle(entry, RandomEntityDataGenerator.property(entity.properties, entry.name()));
                    continue block8;
                }
                case LABEL: {
                    deserialization.handle(entry, (Object)entity.labels());
                    continue block8;
                }
                case TYPE: {
                    deserialization.handle(entry, entity.hasIntType ? Integer.valueOf(entity.intType) : entity.stringType);
                    continue block8;
                }
                case START_ID: {
                    deserialization.handle(entry, entity.hasLongStartId ? Long.valueOf(entity.longStartId) : entity.objectStartId);
                    continue block8;
                }
                case END_ID: {
                    deserialization.handle(entry, entity.hasLongEndId ? Long.valueOf(entity.longEndId) : entity.objectEndId);
                    continue block8;
                }
            }
        }
        return (T)deserialization.materialize();
    }

    private static Object property(List<Object> properties, String key) {
        for (int i = 0; i < properties.size(); i += 2) {
            if (!properties.get(i).equals(key)) continue;
            return properties.get(i + 1);
        }
        return null;
    }
}

