/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringCollisionValues;

@RunWith(value=Parameterized.class)
public class StringCollisionValuesTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule(DefaultFileSystemRule::new, this.getClass());
    @Rule
    public final RandomRule random = new RandomRule().withConfiguration((Randoms.Configuration)new Randoms.Default(){

        public int stringMaxLength() {
            return 65535;
        }
    });
    @Parameterized.Parameter(value=0)
    public Function<PageCacheAndDependenciesRule, NumberArrayFactory> factory;

    @Parameterized.Parameters
    public static Collection<Function<PageCacheAndDependenciesRule, NumberArrayFactory>> data() {
        return Arrays.asList(storage -> NumberArrayFactory.HEAP, storage -> NumberArrayFactory.OFF_HEAP, storage -> NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, storage -> NumberArrayFactory.CHUNKED_FIXED_SIZE, storage -> new PageCachedNumberArrayFactory(storage.pageCache(), storage.directory().directory()));
    }

    @Test
    public void shouldStoreAndLoadStrings() {
        try (StringCollisionValues values = new StringCollisionValues(this.factory.apply(this.storage), 10000L);){
            int i;
            long[] offsets = new long[100];
            String[] strings = new String[offsets.length];
            for (i = 0; i < offsets.length; ++i) {
                String string = this.random.string();
                offsets[i] = values.add((Object)string);
                strings[i] = string;
            }
            for (i = 0; i < offsets.length; ++i) {
                Assert.assertEquals((Object)strings[i], (Object)values.get(offsets[i]));
            }
        }
    }

    @Test
    public void shouldMoveOverToNextChunkOnNearEnd() {
        try (StringCollisionValues values = new StringCollisionValues(this.factory.apply(this.storage), 10000L);){
            char[] chars = new char[8189];
            Arrays.fill(chars, 'a');
            String string = String.valueOf(chars);
            long offset = values.add((Object)string);
            String secondString = "abcdef";
            long secondOffset = values.add((Object)secondString);
            String readString = (String)values.get(offset);
            Assert.assertEquals((Object)string, (Object)readString);
            String readSecondString = (String)values.get(secondOffset);
            Assert.assertEquals((Object)secondString, (Object)readSecondString);
        }
    }
}

