/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoggerRule
extends ExternalResource {
    private final Level level;
    private Logger logger;
    private String testName;

    public LoggerRule() {
        this(Level.INFO);
    }

    public LoggerRule(Level level) {
        this.level = level;
    }

    protected void before() throws Throwable {
        this.logger.info("Begin test:" + this.testName);
        super.before();
    }

    protected void after() {
        super.after();
        this.logger.info("Finished test:" + this.testName);
    }

    public Statement apply(Statement base, Description description) {
        this.testName = description.getDisplayName();
        this.logger = Logger.getLogger(description.getTestClass().getName());
        this.logger.setLevel(this.level);
        return super.apply(base, description);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

