/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.TestDirectory;

public class EmbeddedDatabaseRule
extends DatabaseRule {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Override
    public EmbeddedDatabaseRule startLazily() {
        return (EmbeddedDatabaseRule)super.startLazily();
    }

    @Override
    public File getStoreDir() {
        return this.testDirectory.graphDbDir();
    }

    @Override
    public String getStoreDirAbsolutePath() {
        return this.testDirectory.graphDbDir().getAbsolutePath();
    }

    @Override
    protected GraphDatabaseFactory newFactory() {
        return new TestGraphDatabaseFactory();
    }

    @Override
    protected GraphDatabaseBuilder newBuilder(GraphDatabaseFactory factory) {
        return factory.newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir());
    }

    public Statement apply(Statement base, Description description) {
        return this.testDirectory.apply(super.apply(base, description), description);
    }

    public TestDirectory getTestDirectory() {
        return this.testDirectory;
    }
}

