/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class GraphDatabaseServiceCleaner {
    private GraphDatabaseServiceCleaner() {
        throw new UnsupportedOperationException();
    }

    public static void cleanDatabaseContent(GraphDatabaseService db) {
        GraphDatabaseServiceCleaner.cleanupSchema(db);
        GraphDatabaseServiceCleaner.cleanupAllRelationshipsAndNodes(db);
    }

    public static void cleanupSchema(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (ConstraintDefinition constraint : db.schema().getConstraints()) {
                constraint.drop();
            }
            for (IndexDefinition index : db.schema().getIndexes()) {
                index.drop();
            }
            tx.success();
        }
    }

    public static void cleanupAllRelationshipsAndNodes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (Relationship relationship : db.getAllRelationships()) {
                relationship.delete();
            }
            for (Node node : db.getAllNodes()) {
                node.delete();
            }
            tx.success();
        }
    }
}

