/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CheckPointThresholdTestSupport {
    protected Config config;
    protected FakeClock clock;
    protected LogPruning logPruning;
    protected LogProvider logProvider;
    protected Integer intervalTx;
    protected Duration intervalTime;
    protected Consumer<String> notTriggered;
    protected BlockingQueue<String> triggerConsumer;
    protected Consumer<String> triggered;

    @Before
    public void setUp() {
        this.config = Config.defaults();
        this.clock = Clocks.fakeClock();
        this.logPruning = LogPruning.NO_PRUNING;
        this.logProvider = NullLogProvider.getInstance();
        this.intervalTx = (Integer)this.config.get(GraphDatabaseSettings.check_point_interval_tx);
        this.intervalTime = (Duration)this.config.get(GraphDatabaseSettings.check_point_interval_time);
        this.triggerConsumer = new LinkedBlockingQueue<String>();
        this.triggered = this.triggerConsumer::offer;
        this.notTriggered = s -> Assert.fail((String)("Should not have triggered: " + s));
    }

    protected void withPolicy(String policy) {
        this.config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.check_point_policy.name(), policy}));
    }

    protected void withIntervalTime(String time) {
        this.config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.check_point_interval_time.name(), time}));
    }

    protected void withIntervalTx(int count) {
        this.config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.check_point_interval_tx.name(), String.valueOf(count)}));
    }

    protected CheckPointThreshold createThreshold() {
        return CheckPointThreshold.createThreshold((Config)this.config, (Clock)this.clock, (LogPruning)this.logPruning, (LogProvider)this.logProvider);
    }

    protected void verifyTriggered(String reason) {
        Assert.assertThat(this.triggerConsumer.poll(), (Matcher)Matchers.containsString((String)reason));
    }

    protected void verifyNoMoreTriggers() {
        Assert.assertTrue((boolean)this.triggerConsumer.isEmpty());
    }
}

