/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

public class AbstractCheckPointThresholdTest {
    @Test
    public void shouldCallConsumerProvidingTheDescriptionWhenThresholdIsTrue() {
        String description = "description";
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(true, description);
        AtomicReference calledWith = new AtomicReference();
        threshold.isCheckPointingNeeded(42L, calledWith::set);
        Assert.assertEquals((Object)description, calledWith.get());
    }

    @Test
    public void shouldNotCallConsumerProvidingTheDescriptionWhenThresholdIsFalse() {
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(false, null);
        threshold.isCheckPointingNeeded(42L, s -> {
            throw new IllegalStateException("nooooooooo!");
        });
    }

    private static class TheAbstractCheckPointThreshold
    extends AbstractCheckPointThreshold {
        private final boolean reached;

        TheAbstractCheckPointThreshold(boolean reached, String description) {
            super(description);
            this.reached = reached;
        }

        public void initialize(long transactionId) {
        }

        public void checkPointHappened(long transactionId) {
        }

        public long checkFrequencyMillis() {
            return DEFAULT_CHECKING_FREQUENCY_MILLIS;
        }

        protected boolean thresholdReached(long lastCommittedTransactionId) {
            return this.reached;
        }
    }
}

