/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

public class MockStore
extends Read
implements TestRule {
    private static final DynamicRecordAllocator NO_DYNAMIC_RECORDS = new DynamicRecordAllocator(){

        public int getRecordDataSize() {
            throw new UnsupportedOperationException("Should not allocate dynamic records");
        }

        public DynamicRecord nextRecord() {
            throw new UnsupportedOperationException("Should not allocate dynamic records");
        }
    };
    private PrimitiveLongObjectMap<Node> nodes;
    private PrimitiveLongObjectMap<Property> properties;

    MockStore(DefaultCursors cursors) {
        super(cursors, (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class));
    }

    long graphPropertiesReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    IndexReader indexReader(IndexReference index, boolean fresh) {
        throw new UnsupportedOperationException("not implemented");
    }

    LabelScanReader labelScanReader() {
        throw new UnsupportedOperationException("not implemented");
    }

    ExplicitIndex explicitNodeIndex(String indexName) {
        throw new UnsupportedOperationException("not implemented");
    }

    ExplicitIndex explicitRelationshipIndex(String indexName) {
        throw new UnsupportedOperationException("not implemented");
    }

    PageCursor nodePage(long reference) {
        return null;
    }

    PageCursor relationshipPage(long reference) {
        return null;
    }

    PageCursor groupPage(long reference) {
        return null;
    }

    PageCursor propertyPage(long reference) {
        return null;
    }

    PageCursor stringPage(long reference) {
        return null;
    }

    PageCursor arrayPage(long reference) {
        return null;
    }

    RecordCursor<DynamicRecord> labelCursor() {
        return new RecordCursor<DynamicRecord>(){

            public RecordCursor<DynamicRecord> acquire(long id, RecordLoad mode) {
                this.placeAt(id, mode);
                return this;
            }

            public void placeAt(long id, RecordLoad mode) {
                throw new UnsupportedOperationException("not implemented");
            }

            public boolean next() {
                throw new UnsupportedOperationException("not implemented");
            }

            public boolean next(long id) {
                throw new UnsupportedOperationException("not implemented");
            }

            public boolean next(long id, DynamicRecord record, RecordLoad mode) {
                throw new UnsupportedOperationException("not implemented");
            }

            public void close() {
            }

            public DynamicRecord get() {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    public boolean nodeExists(long id) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long countsForNode(int labelId) {
        throw new UnsupportedOperationException();
    }

    public long countsForNodeWithoutTxState(int labelId) {
        throw new UnsupportedOperationException();
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        throw new UnsupportedOperationException();
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        throw new UnsupportedOperationException();
    }

    public long nodesGetCount() {
        throw new UnsupportedOperationException();
    }

    public long relationshipsGetCount() {
        throw new UnsupportedOperationException();
    }

    public boolean relationshipExists(long reference) {
        throw new UnsupportedOperationException("not implemented");
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Set<ProcedureSignature> proceduresGetAll() throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(int id, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException("not implemented");
    }

    public AnyValue functionCall(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public AnyValue functionCallOverride(QualifiedName name, AnyValue[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public UserAggregator aggregationFunction(QualifiedName name) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public UserAggregator aggregationFunctionOverride(QualifiedName name) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public ValueMapper<Object> valueMapper() {
        throw new UnsupportedOperationException();
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public AnyValue functionCallOverride(int id, AnyValue[] arguments) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public UserAggregator aggregationFunction(int id) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public UserAggregator aggregationFunctionOverride(int id) throws ProcedureException {
        throw new UnsupportedOperationException();
    }

    public boolean nodeExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> nodeExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    public boolean relationshipExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        throw new UnsupportedOperationException();
    }

    public String[] nodeExplicitIndexesGetAll() {
        throw new UnsupportedOperationException();
    }

    public String[] relationshipExplicitIndexesGetAll() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> relationshipExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try (PrimitiveLongObjectMap nodes = Primitive.longObjectMap();
                     PrimitiveLongObjectMap properties = Primitive.longObjectMap();){
                    MockStore.this.nodes = nodes;
                    MockStore.this.properties = properties;
                    base.evaluate();
                }
                finally {
                    MockStore.this.nodes = null;
                    MockStore.this.properties = null;
                }
            }
        };
    }

    private static <R extends AbstractBaseRecord, S extends Record<R>> void initialize(R record, long reference, PrimitiveLongObjectMap<S> store) {
        record.setId(reference);
        Record node = (Record)store.get(reference);
        if (node == null) {
            record.clear();
        } else {
            node.initialize(record);
        }
    }

    public void node(long id, long property, boolean dense, long edge, long labels) {
        this.nodes.put(id, (Object)new Node(property, dense, edge, labels));
    }

    public void property(long id, long prev, long next, PropertyBlock ... payload) {
        this.properties.put(id, (Object)new Property(prev, next, payload));
    }

    public static PropertyBlock block(int key, Value value) {
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)key, (Value)value, (DynamicRecordAllocator)NO_DYNAMIC_RECORDS, (DynamicRecordAllocator)NO_DYNAMIC_RECORDS, (boolean)true);
        return block;
    }

    void node(NodeRecord record, long reference, PageCursor pageCursor) {
        MockStore.initialize(record, reference, this.nodes);
    }

    void relationship(RelationshipRecord record, long reference, PageCursor pageCursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    void relationshipFull(RelationshipRecord record, long reference, PageCursor pageCursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    void property(PropertyRecord record, long reference, PageCursor pageCursor) {
        MockStore.initialize(record, reference, this.properties);
    }

    void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        throw new UnsupportedOperationException("not implemented");
    }

    long nodeHighMark() {
        throw new UnsupportedOperationException("not implemented");
    }

    long relationshipHighMark() {
        throw new UnsupportedOperationException("not implemented");
    }

    TextValue string(DefaultPropertyCursor cursor, long reference, PageCursor page) {
        throw new UnsupportedOperationException("not implemented");
    }

    ArrayValue array(DefaultPropertyCursor cursor, long reference, PageCursor page) {
        throw new UnsupportedOperationException("not implemented");
    }

    public CapableIndexReference index(int label, int ... properties) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<IndexReference> indexesGetForLabel(int labelId) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<IndexReference> indexesGetAll() {
        throw new UnsupportedOperationException("not implemented");
    }

    public InternalIndexState indexGetState(IndexReference index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public PopulationProgress indexGetPopulationProgress(IndexReference index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long indexGetCommittedId(IndexReference index) throws SchemaKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public String indexGetFailure(IndexReference index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public double indexUniqueValuesSelectivity(IndexReference index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long indexSize(IndexReference index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long nodesCountIndexed(IndexReference index, long nodeId, Value value) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Register.DoubleLongRegister indexSample(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Long indexGetOwningUniquenessConstraintId(IndexReference index) {
        return null;
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <K, V> V schemaStateGet(K key) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void schemaStateFlush() {
        throw new UnsupportedOperationException("not implemented");
    }

    private static class Property
    extends Record<PropertyRecord> {
        private final long prev;
        private final long next;
        private final PropertyBlock[] payload;

        Property(long prev, long next, PropertyBlock[] payload) {
            this.prev = prev;
            this.next = next;
            this.payload = payload;
        }

        @Override
        void initialize(PropertyRecord record) {
            record.initialize(true, this.prev, this.next);
            for (PropertyBlock block : this.payload) {
                for (long value : block.getValueBlocks()) {
                    record.addLoadedBlock(value);
                }
            }
        }
    }

    private static class Node
    extends Record<NodeRecord> {
        private final long property;
        private final boolean dense;
        private final long edge;
        private final long labels;

        Node(long property, boolean dense, long edge, long labels) {
            this.property = property;
            this.dense = dense;
            this.edge = edge;
            this.labels = labels;
        }

        @Override
        void initialize(NodeRecord record) {
            record.initialize(true, this.property, this.dense, this.edge, this.labels);
        }
    }

    private static abstract class Record<R extends AbstractBaseRecord> {
        private Record() {
        }

        abstract void initialize(R var1);
    }
}

