/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.storageengine.api.schema.IndexProgressor;

public class IndexCursorTest {
    @Test
    public void shouldClosePreviousBeforeReinitialize() {
        StubIndexCursor cursor = new StubIndexCursor();
        StubProgressor progressor = new StubProgressor();
        cursor.initialize(progressor);
        Assert.assertFalse((String)"open before re-initialize", (boolean)progressor.isClosed);
        StubProgressor otherProgressor = new StubProgressor();
        cursor.initialize(otherProgressor);
        Assert.assertTrue((String)"closed after re-initialize", (boolean)progressor.isClosed);
        Assert.assertFalse((String)"new still open", (boolean)otherProgressor.isClosed);
    }

    private static class StubProgressor
    implements IndexProgressor {
        boolean isClosed = false;

        StubProgressor() {
        }

        public boolean next() {
            return false;
        }

        public void close() {
            this.isClosed = true;
        }
    }

    private static class StubIndexCursor
    extends IndexCursor<StubProgressor> {
        private StubIndexCursor() {
        }
    }
}

