/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeSchemaKey;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

public class ZonedDateTimeLayoutTest {
    @Test
    public void shouldReadAndWriteConsistentValues() {
        Value[] values = new Value[]{DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("-18:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneOffset)ZoneOffset.of("-17:59:59")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm")), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00")), DateTimeValue.datetime((long)10000L, (long)101L, (ZoneId)ZoneId.of("-18:00"))};
        ZonedDateTimeLayout layout = new ZonedDateTimeLayout();
        StubPageCursor cursor = new StubPageCursor(0L, 8192);
        ZonedDateTimeSchemaKey writeKey = layout.newKey();
        ZonedDateTimeSchemaKey readKey = layout.newKey();
        for (Value value : values) {
            value.writeTo((ValueWriter)writeKey);
            layout.writeKey((PageCursor)cursor, writeKey);
        }
        cursor.setOffset(0);
        for (Value value : values) {
            layout.readKey((PageCursor)cursor, readKey, 24);
            Assert.assertEquals((Object)value, (Object)readKey.asValue());
        }
    }
}

