/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeSchemaKey;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TimeLayoutTestUtil
extends LayoutTestUtil<ZonedTimeSchemaKey, NativeSchemaValue> {
    static long MAX_NANOS_PER_DAY = 86399999999999L;
    private static final OffsetTime[] ALL_EXTREME_VALUES = new OffsetTime[]{OffsetTime.of(0, 0, 0, 0, ZoneOffset.ofHours(-18)), OffsetTime.of(0, 0, 0, 0, ZoneOffset.ofHours(18)), OffsetTime.of(12, 0, 0, 0, ZoneOffset.ofHours(-18)), OffsetTime.of(12, 0, 0, 0, ZoneOffset.ofHours(18)), OffsetTime.of(23, 59, 59, 999999999, ZoneOffset.ofHours(18)), OffsetTime.of(23, 59, 59, 999999999, ZoneOffset.ofHours(-18))};

    public static TimeValue randomTime(Randoms random) {
        return TimeValue.time((OffsetTime)random.randomTime());
    }

    TimeLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<ZonedTimeSchemaKey, NativeSchemaValue> createLayout() {
        return new ZonedTimeLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(ZonedTimeSchemaKey key1, ZonedTimeSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        TimeValue candidate;
        while (!uniqueCompareValues.add(candidate = TimeLayoutTestUtil.randomTime(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

