/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.PathProxy;

public class PathProxyTest {
    @Test
    public void shouldIterateThroughNodes() {
        PathProxy path = new PathProxy(null, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.nodes().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)1L, (long)node.getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)2L, (long)node.getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)3L, (long)node.getId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldIterateThroughNodesInReverse() {
        PathProxy path = new PathProxy(null, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseNodes().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)3L, (long)node.getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)2L, (long)node.getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        Assert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)1L, (long)node.getId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldIterateThroughRelationships() {
        PathProxy path = new PathProxy(null, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.relationships().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        Assert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)100L, (long)relationship.getId());
        Assert.assertEquals((long)1L, (long)relationship.getStartNodeId());
        Assert.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assert.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        Assert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)200L, (long)relationship.getId());
        Assert.assertEquals((long)3L, (long)relationship.getStartNodeId());
        Assert.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldIterateThroughRelationshipsInReverse() {
        PathProxy path = new PathProxy(null, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseRelationships().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        Assert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)200L, (long)relationship.getId());
        Assert.assertEquals((long)3L, (long)relationship.getStartNodeId());
        Assert.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assert.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        Assert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)100L, (long)relationship.getId());
        Assert.assertEquals((long)1L, (long)relationship.getStartNodeId());
        Assert.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldIterateAlternatingNodesAndRelationships() {
        PathProxy path = new PathProxy(null, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        PropertyContainer entity = (PropertyContainer)iterator.next();
        Assert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)1L, (long)((Entity)entity).getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        entity = (PropertyContainer)iterator.next();
        Assert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)100L, (long)((Entity)entity).getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        entity = (PropertyContainer)iterator.next();
        Assert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)2L, (long)((Entity)entity).getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        entity = (PropertyContainer)iterator.next();
        Assert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Relationship.class));
        Assert.assertEquals((long)200L, (long)((Entity)entity).getId());
        Assert.assertTrue((boolean)iterator.hasNext());
        entity = (PropertyContainer)iterator.next();
        Assert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assert.assertEquals((long)3L, (long)((Entity)entity).getId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

