/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class ProceduresKernelIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final CallableProcedure procedure = ProceduresKernelIT.procedure(this.signature);

    @Test
    public void shouldGetProcedureByName() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        ProcedureSignature found = this.procs().procedureGet(new QualifiedName(new String[]{"example"}, "exampleProc")).signature();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)this.signature));
        this.commit();
    }

    @Test
    public void shouldGetBuiltInProcedureByName() throws Throwable {
        ProcedureSignature found = this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).signature();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)ProcedureSignature.procedureSignature((QualifiedName)ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).out("label", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        this.commit();
    }

    @Test
    public void shouldGetAllProcedures() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        List signatures = Iterables.asList((Iterable)this.newTransaction().procedures().proceduresGetAll());
        MatcherAssert.assertThat((Object)signatures, (Matcher)IsCollectionContaining.hasItems((Object[])new ProcedureSignature[]{this.procedure.signature(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()}));
        this.commit();
    }

    @Test
    public void shouldRefuseToRegisterNonVoidProcedureWithoutOutputs() throws ProcedureException, TransactionFailureException {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Procedures with zero output fields must be declared as VOID");
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).build()));
        this.commit();
    }

    @Test
    public void shouldCallReadOnlyProcedure() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        RawIterator found = this.procs().procedureCallRead(this.procs().procedureGet(new QualifiedName(new String[]{"example"}, "exampleProc")).id(), new Object[]{1337});
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)found), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{1337})));
        this.commit();
    }

    @Test
    public void registeredProcedureShouldGetRead() throws Throwable {
        this.internalKernel().registerProcedure((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                return RawIterator.of((Object[])new Object[][]{{((KernelTransaction)ctx.get(Context.KERNEL_TRANSACTION)).dataRead()}});
            }
        });
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(this.signature.name()).id(), new Object[]{""});
        Assert.assertNotNull((Object)((Object[])Iterators.asList((RawIterator)stream).get(0))[0]);
        this.commit();
    }

    private static CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) {
                return RawIterator.of((Object[])new Object[][]{input});
            }
        };
    }
}

