/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.PageCacheFlusher;
import org.neo4j.unsafe.impl.batchimport.store.io.IoTracer;

public class BatchingNeoStores
implements AutoCloseable,
MemoryStatsVisitor.Visitable {
    static final long DOUBLE_RELATIONSHIP_RECORD_UNIT_THRESHOLD = 0x200000000L;
    private static final String TEMP_NEOSTORE_NAME = "temp.neostore";
    private static final StoreType[] TEMP_STORE_TYPES = new StoreType[]{StoreType.RELATIONSHIP_GROUP, StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING};
    private final FileSystemAbstraction fileSystem;
    private final LogProvider logProvider;
    private final File storeDir;
    private final Config neo4jConfig;
    private final Configuration importConfiguration;
    private final PageCache pageCache;
    private final IoTracer ioTracer;
    private final RecordFormats recordFormats;
    private final AdditionalInitialIds initialIds;
    private final boolean externalPageCache;
    private final IdGeneratorFactory idGeneratorFactory;
    private NeoStores neoStores;
    private NeoStores temporaryNeoStores;
    private BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private LifeSupport life = new LifeSupport();
    private LabelScanStore labelScanStore;
    private PageCacheFlusher flusher;
    private boolean doubleRelationshipRecordUnits;
    private boolean successful;

    private BatchingNeoStores(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, RecordFormats recordFormats, Config neo4jConfig, Configuration importConfiguration, LogService logService, AdditionalInitialIds initialIds, boolean externalPageCache, IoTracer ioTracer) {
        this.fileSystem = fileSystem;
        this.recordFormats = recordFormats;
        this.importConfiguration = importConfiguration;
        this.initialIds = initialIds;
        this.logProvider = logService.getInternalLogProvider();
        this.storeDir = storeDir;
        this.neo4jConfig = neo4jConfig;
        this.pageCache = pageCache;
        this.ioTracer = ioTracer;
        this.externalPageCache = externalPageCache;
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem);
    }

    private boolean databaseExistsAndContainsData() {
        Throwable throwable;
        File metaDataFile = new File(this.storeDir, StoreType.META_DATA.getStoreFile().fileName(StoreFileType.STORE));
        try {
            PagedFile pagedFile = this.pageCache.map(metaDataFile, this.pageCache.pageSize(), new OpenOption[]{StandardOpenOption.READ});
            throwable = null;
            if (pagedFile != null) {
                if (throwable != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        throwable = null;
        try (NeoStores stores = this.newStoreFactory("neostore", new OpenOption[0]).openNeoStores(StoreType.NODE, StoreType.RELATIONSHIP);){
            boolean bl = stores.getNodeStore().getHighId() > 0L || stores.getRelationshipStore().getHighId() > 0L;
            return bl;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public void createNew() throws IOException {
        this.assertDatabaseIsEmptyOrNonExistent();
        this.fileSystem.deleteFile(NativeLabelScanStore.getLabelScanStoreFile(this.storeDir));
        this.instantiateStores();
        this.neoStores.getMetaDataStore().setLastCommittedAndClosedTransactionId(this.initialIds.lastCommittedTransactionId(), this.initialIds.lastCommittedTransactionChecksum(), 0L, this.initialIds.lastCommittedTransactionLogByteOffset(), this.initialIds.lastCommittedTransactionLogVersion());
        this.neoStores.startCountStore();
    }

    public void assertDatabaseIsEmptyOrNonExistent() {
        if (this.databaseExistsAndContainsData()) {
            throw new IllegalStateException(this.storeDir + " already contains data, cannot do import here");
        }
    }

    public void pruneAndOpenExistingStore(Predicate<StoreType> mainStoresToKeep, Predicate<StoreType> tempStoresToKeep) throws IOException {
        this.deleteStoreFiles(TEMP_NEOSTORE_NAME, tempStoresToKeep);
        this.deleteStoreFiles("neostore", mainStoresToKeep);
        this.instantiateStores();
        this.neoStores.startCountStore();
    }

    private void deleteStoreFiles(String storeName, Predicate<StoreType> storesToKeep) {
        FileSystemAbstraction fs = this.pageCache.getCachedFileSystem();
        for (StoreType type : StoreType.values()) {
            if (!type.isRecordStore() || storesToKeep.test(type)) continue;
            for (StoreFileType fileType : StoreFileType.values()) {
                fs.deleteFile(new File(this.storeDir, fileType.augment(storeName + type.getStoreFile().fileNamePart())));
            }
        }
    }

    private void instantiateKernelExtensions() {
        this.life = new LifeSupport();
        this.life.start();
        this.labelScanStore = new NativeLabelScanStore(this.pageCache, this.storeDir, FullStoreChangeStream.EMPTY, false, new Monitors(), RecoveryCleanupWorkCollector.IMMEDIATE);
        this.life.add((Lifecycle)this.labelScanStore);
    }

    private void instantiateStores() {
        this.neoStores = this.newStoreFactory("neostore", new OpenOption[0]).openAllNeoStores(true);
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStores.getPropertyKeyTokenStore());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStores.getLabelTokenStore());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStores.getRelationshipTypeTokenStore());
        this.temporaryNeoStores = this.instantiateTempStores();
        this.instantiateKernelExtensions();
        this.neoStores.makeStoreOk();
        this.temporaryNeoStores.makeStoreOk();
    }

    private NeoStores instantiateTempStores() {
        return this.newStoreFactory(TEMP_NEOSTORE_NAME, new OpenOption[0]).openNeoStores(true, TEMP_STORE_TYPES);
    }

    public static BatchingNeoStores batchingNeoStores(FileSystemAbstraction fileSystem, File storeDir, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        PageCache pageCache = BatchingNeoStores.createPageCache(fileSystem, neo4jConfig, logService.getInternalLogProvider(), (PageCacheTracer)tracer, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, EmptyVersionContextSupplier.EMPTY);
        return new BatchingNeoStores(fileSystem, pageCache, storeDir, recordFormats, neo4jConfig, config, logService, initialIds, false, () -> ((PageCacheTracer)tracer).bytesWritten());
    }

    public static BatchingNeoStores batchingNeoStoresWithExternalPageCache(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer tracer, File storeDir, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(config, dbConfig);
        return new BatchingNeoStores(fileSystem, pageCache, storeDir, recordFormats, neo4jConfig, config, logService, initialIds, true, () -> ((PageCacheTracer)tracer).bytesWritten());
    }

    private static Config getNeo4jConfig(Configuration config, Config dbConfig) {
        dbConfig.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()), GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(config.pageCacheMemory())}));
        return dbConfig;
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogProvider log, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier, VersionContextSupplier contextSupplier) {
        return new ConfiguringPageCacheFactory(fileSystem, config, tracer, cursorTracerSupplier, log.getLog(BatchingNeoStores.class), contextSupplier).getOrCreatePageCache();
    }

    private StoreFactory newStoreFactory(String name, OpenOption ... openOptions) {
        return new StoreFactory(this.storeDir, name, this.neo4jConfig, this.idGeneratorFactory, this.pageCache, this.fileSystem, this.recordFormats, this.logProvider, EmptyVersionContextSupplier.EMPTY, openOptions);
    }

    public RecordStore<RelationshipGroupRecord> getTemporaryRelationshipGroupStore() {
        return this.temporaryNeoStores.getRelationshipGroupStore();
    }

    public PropertyStore getTemporaryPropertyStore() {
        return this.temporaryNeoStores.getPropertyStore();
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStores.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStores.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStores.getRelationshipStore();
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.neoStores.getRelationshipGroupStore();
    }

    public CountsTracker getCountsStore() {
        return this.neoStores.getCounts();
    }

    @Override
    public void close() throws IOException {
        if (this.flusher != null) {
            this.stopFlushingPageCache();
        }
        this.flushAndForce();
        IOUtils.closeAll((AutoCloseable[])new BatchingTokenRepository[]{this.propertyKeyRepository, this.labelRepository, this.relationshipTypeRepository});
        this.life.shutdown();
        IOUtils.closeAll((AutoCloseable[])new NeoStores[]{this.neoStores, this.temporaryNeoStores});
        if (!this.externalPageCache) {
            this.pageCache.close();
        }
        if (this.successful) {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.deleteStoreFiles(TEMP_NEOSTORE_NAME, Predicates.alwaysFalse());
    }

    public long getLastCommittedTransactionId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public NeoStores getNeoStores() {
        return this.neoStores;
    }

    public void startFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher != null) {
                throw new IllegalStateException("Flusher already started");
            }
            this.flusher = new PageCacheFlusher(this.pageCache);
            this.flusher.start();
        }
    }

    public void stopFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher == null) {
                throw new IllegalStateException("Flusher not started");
            }
            this.flusher.halt();
            this.flusher = null;
        }
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.pageCache.maxCachedPages() * (long)this.pageCache.pageSize());
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public void flushAndForce() {
        if (this.propertyKeyRepository != null) {
            this.propertyKeyRepository.flush();
        }
        if (this.labelRepository != null) {
            this.labelRepository.flush();
        }
        if (this.relationshipTypeRepository != null) {
            this.relationshipTypeRepository.flush();
        }
        if (this.neoStores != null) {
            this.neoStores.flush(IOLimiter.unlimited());
            this.flushIdFiles(this.neoStores, StoreType.values());
        }
        if (this.temporaryNeoStores != null) {
            this.temporaryNeoStores.flush(IOLimiter.unlimited());
            this.flushIdFiles(this.temporaryNeoStores, TEMP_STORE_TYPES);
        }
        if (this.labelScanStore != null) {
            this.labelScanStore.force(IOLimiter.unlimited());
        }
    }

    public void success() {
        this.successful = true;
    }

    public boolean determineDoubleRelationshipRecordUnits(Input.Estimates inputEstimates) {
        this.doubleRelationshipRecordUnits = this.recordFormats.hasCapability(Capability.SECONDARY_RECORD_UNITS) && inputEstimates.numberOfRelationships() > 0x200000000L;
        return this.doubleRelationshipRecordUnits;
    }

    public boolean usesDoubleRelationshipRecordUnits() {
        return this.doubleRelationshipRecordUnits;
    }

    private void flushIdFiles(NeoStores neoStores, StoreType[] storeTypes) {
        for (StoreType type : storeTypes) {
            if (!type.isRecordStore()) continue;
            RecordStore recordStore = neoStores.getRecordStore(type);
            this.idGeneratorFactory.create(new File(this.storeDir, type.getStoreFile().fileName(StoreFileType.ID)), recordStore.getHighId(), false);
        }
    }
}

