/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingLongIterator;
import org.neo4j.kernel.impl.util.diffsets.SuperDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class DiffSets<T>
extends SuperDiffSets<T>
implements ReadableDiffSets<T> {
    public DiffSets() {
        this(null, null);
    }

    public DiffSets(Set<T> addedElements, Set<T> removedElements) {
        super(addedElements, removedElements);
    }

    @Override
    public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
        return DiffApplyingLongIterator.augment(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveLongResourceIterator augment(PrimitiveLongResourceIterator source) {
        return DiffApplyingLongIterator.augment(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveLongResourceIterator augmentWithRemovals(PrimitiveLongResourceIterator source) {
        return DiffApplyingLongIterator.augment(source, Collections.emptySet(), this.removed(false));
    }

    @Override
    public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new DiffSets<T>(Iterables.asSet((Iterable)Iterables.filter(addedFilter, this.added(false))), Iterables.asSet(this.removed(false)));
    }
}

