/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.List;
import java.util.function.Supplier;
import org.neo4j.concurrent.Work;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class LabelUpdateWork
implements Work<Supplier<LabelScanWriter>, LabelUpdateWork> {
    private final List<NodeLabelUpdate> labelUpdates;

    public LabelUpdateWork(List<NodeLabelUpdate> labelUpdates) {
        this.labelUpdates = labelUpdates;
    }

    public LabelUpdateWork combine(LabelUpdateWork work) {
        this.labelUpdates.addAll(work.labelUpdates);
        return this;
    }

    public void apply(Supplier<LabelScanWriter> labelScanStore) {
        this.labelUpdates.sort(NodeLabelUpdate.SORT_BY_NODE_ID);
        try (LabelScanWriter writer = labelScanStore.get();){
            for (NodeLabelUpdate update : this.labelUpdates) {
                writer.write(update);
            }
        }
        catch (Exception e) {
            throw new UnderlyingStorageException(e);
        }
    }
}

