/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayDeque;
import java.util.Queue;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

public class BridgingIndexProgressor
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private final IndexProgressor.NodeValueClient client;
    private final int[] keys;
    private final Queue<IndexProgressor> progressors;
    private IndexProgressor current;

    public BridgingIndexProgressor(IndexProgressor.NodeValueClient client, int[] keys) {
        this.client = client;
        this.keys = keys;
        this.progressors = new ArrayDeque<IndexProgressor>();
    }

    @Override
    public boolean next() {
        if (this.current == null) {
            this.current = this.progressors.poll();
        }
        while (this.current != null) {
            if (this.current.next()) {
                return true;
            }
            this.current.close();
            this.current = this.progressors.poll();
        }
        return false;
    }

    @Override
    public void close() {
        this.progressors.forEach(IndexProgressor::close);
    }

    @Override
    public boolean needsValues() {
        return this.client.needsValues();
    }

    @Override
    public void initialize(SchemaIndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] queries) {
        this.assertKeysAlign(descriptor.schema().getPropertyIds());
        this.progressors.add(progressor);
    }

    private void assertKeysAlign(int[] keys) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == keys[i]) continue;
            throw new UnsupportedOperationException("Can not chain multiple progressors with different key set.");
        }
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        return this.client.acceptNode(reference, values);
    }
}

