/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeSchemaKey;

class ZonedTimeLayout
extends SchemaLayout<ZonedTimeSchemaKey> {
    ZonedTimeLayout() {
        super("Tzt", 0, 1);
    }

    public ZonedTimeSchemaKey newKey() {
        return new ZonedTimeSchemaKey();
    }

    public ZonedTimeSchemaKey copyKey(ZonedTimeSchemaKey key, ZonedTimeSchemaKey into) {
        into.nanosOfDayUTC = key.nanosOfDayUTC;
        into.zoneOffsetSeconds = key.zoneOffsetSeconds;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(ZonedTimeSchemaKey key) {
        return 20;
    }

    public void writeKey(PageCursor cursor, ZonedTimeSchemaKey key) {
        cursor.putLong(key.nanosOfDayUTC);
        cursor.putInt(key.zoneOffsetSeconds);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, ZonedTimeSchemaKey into, int keySize) {
        into.nanosOfDayUTC = cursor.getLong();
        into.zoneOffsetSeconds = cursor.getInt();
        into.setEntityId(cursor.getLong());
    }
}

