/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.fusion.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialIndexReader
extends SpatialIndexCache<SpatialIndexPartReader<NativeSchemaValue>>
implements IndexReader {
    private final SchemaIndexDescriptor descriptor;

    SpatialIndexReader(SchemaIndexDescriptor descriptor, SpatialIndexAccessor accessor) {
        super(new PartFactory(accessor));
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexBase.forAll(Resource::close, this);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        NativeSchemaIndexReader partReader = (NativeSchemaIndexReader)this.uncheckedSelect(((PointValue)propertyValues[0]).getCoordinateReferenceSystem());
        return partReader == null ? 0L : partReader.countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler((IndexSampler[])Iterators.stream(this.iterator()).map(IndexReader::createSampler).toArray(IndexSampler[]::new));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, predicates);
        return nodeValueIterator;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) {
        if (predicates.length != 1) {
            throw new IllegalArgumentException("Only single property spatial indexes are supported.");
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExistsPredicate) {
            this.loadAll();
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            for (NativeSchemaIndexReader reader : this) {
                reader.query(multiProgressor, indexOrder, predicates);
            }
        } else if (this.validPredicate(predicate)) {
            CoordinateReferenceSystem crs;
            if (predicate instanceof IndexQuery.ExactPredicate) {
                crs = ((PointValue)((IndexQuery.ExactPredicate)predicate).value()).getCoordinateReferenceSystem();
            } else if (predicate instanceof IndexQuery.GeometryRangePredicate) {
                crs = ((IndexQuery.GeometryRangePredicate)predicate).crs();
            } else {
                throw new IllegalArgumentException("Wrong type of predicate, couldn't get CoordinateReferenceSystem");
            }
            SpatialIndexPartReader part = (SpatialIndexPartReader)this.uncheckedSelect(crs);
            if (part != null) {
                part.query(cursor, indexOrder, predicates);
            } else {
                cursor.initialize(this.descriptor, IndexProgressor.EMPTY, predicates);
            }
        } else {
            cursor.initialize(this.descriptor, IndexProgressor.EMPTY, predicates);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    private boolean validPredicate(IndexQuery predicate) {
        return predicate instanceof IndexQuery.ExactPredicate || predicate instanceof IndexQuery.RangePredicate;
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<SpatialIndexPartReader<NativeSchemaValue>> {
        private final SpatialIndexAccessor accessor;

        PartFactory(SpatialIndexAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public SpatialIndexPartReader<NativeSchemaValue> newSpatial(CoordinateReferenceSystem crs) {
            return this.accessor.selectOrElse(crs, SpatialIndexAccessor.PartAccessor::newReader, null);
        }
    }
}

