/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacheWriter;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacheWriter;

public class InputEntityCacherTokenCreationTest {
    private static final int SUPPORTED_NUMBER_OF_TOKENS = 10;
    private static final int UNSUPPORTED_NUMER_OF_TOKENS = 11;
    private static final AtomicInteger uniqueIdGenerator = new AtomicInteger(10);
    private final ExpectedException expectedException = ExpectedException.none();
    private final RandomRule randomRule = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.randomRule).around((TestRule)this.expectedException);

    @Test
    public void notAllowCreationOfUnsupportedNumberOfProperties() throws IOException {
        this.initExpectedException(10);
        this.cacheNodeWithProperties(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfProperties() throws IOException {
        this.cacheNodeWithProperties(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfGroups() throws IOException {
        this.initExpectedException(10);
        this.cacheGroups(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfGroups() throws IOException {
        this.cacheGroups(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfLabels() throws IOException {
        this.initExpectedException(10);
        this.cacheLabels(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfLabels() throws IOException {
        this.cacheLabels(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfRelationshipTypes() throws IOException {
        this.initExpectedException(10);
        this.cacheRelationship(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfRelationshipTypes() throws IOException {
        this.cacheRelationship(10, 10);
    }

    private void cacheRelationship(int iterations, int maxNumberOfRelationshipTypes) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, 1000L, maxNumberOfRelationshipTypes, 1000L);
        try (InputRelationshipCacheWriter cacher = this.getRelationshipCacher(recordFormats);
             InputEntityVisitor visitor = cacher.wrap((InputEntityVisitor)new InputEntity());){
            for (int i = 0; i < iterations; ++i) {
                this.generateRelationship(this.getRandoms(), visitor);
            }
        }
    }

    private void cacheLabels(int iterations, int maxNumberOfLabels) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, maxNumberOfLabels, 1000L, 1000L);
        try (InputNodeCacheWriter cacher = this.getNodeCacher(recordFormats);
             InputEntityVisitor visitor = cacher.wrap((InputEntityVisitor)new InputEntity());){
            for (int i = 0; i < iterations; ++i) {
                this.generateNode(this.getRandoms(), visitor);
            }
        }
    }

    private void cacheGroups(int iterations, int maxNumberOfGroups) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, 1000L, 1000L, maxNumberOfGroups);
        try (InputNodeCacheWriter cacher = this.getNodeCacher(recordFormats);
             InputEntityVisitor visitor = cacher.wrap((InputEntityVisitor)new InputEntity());){
            Randoms randoms = this.getRandoms();
            for (int i = 0; i < iterations; ++i) {
                this.generateNode(randoms, visitor, false);
            }
        }
    }

    private void cacheNodeWithProperties(int iterations, int maxNumberOfProperties) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(maxNumberOfProperties, 1000L, 1000L, 1000L);
        try (InputNodeCacheWriter cacher = this.getNodeCacher(recordFormats);
             InputEntityVisitor visitor = cacher.wrap((InputEntityVisitor)new InputEntity());){
            Randoms randoms = this.getRandoms();
            for (int i = 0; i < iterations; ++i) {
                this.generateNode(randoms, visitor);
            }
        }
    }

    private void initExpectedException(int numberOfSupportedTokens) {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Too many tokens. Creation of more then " + numberOfSupportedTokens + " tokens is not supported.");
    }

    private void generateRelationship(Randoms randoms, InputEntityVisitor relationship) throws IOException {
        this.generateProperties(randoms, relationship);
        relationship.startId(this.randomId(randoms), this.generateGroup());
        relationship.endId(this.randomId(randoms), this.generateGroup());
        relationship.type(this.getUniqueString());
        relationship.endOfEntity();
    }

    private void generateNode(Randoms random, InputEntityVisitor node) throws IOException {
        this.generateNode(random, node, true);
    }

    private void generateNode(Randoms random, InputEntityVisitor node, boolean propertiesAndLabels) throws IOException {
        node.id(this.randomId(random), this.generateGroup());
        if (propertiesAndLabels) {
            this.generateProperties(random, node);
            node.labels(this.randomLabels());
        }
        node.endOfEntity();
    }

    private Group generateGroup() {
        return new Group.Adapter(uniqueIdGenerator.getAndIncrement(), this.getUniqueString());
    }

    private String[] randomLabels() {
        String[] labels = new String[1];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.getUniqueString();
        }
        return labels;
    }

    private String getUniqueString() {
        return uniqueIdGenerator.getAndIncrement() + "";
    }

    private void generateProperties(Randoms random, InputEntityVisitor entity) {
        int length = 1;
        for (int i = 0; i < length; ++i) {
            String key = this.getUniqueString();
            String value = random.propertyValue() + "";
            entity.property(key, (Object)value);
        }
    }

    private Object randomId(Randoms random) {
        return Math.abs(random.random().nextLong());
    }

    private RecordFormats mockRecordFormats(long maxPropertyKeyId, long maxLabelId, long maxRelationshipTypeId, long maxRelationshipGroupId) {
        RecordFormats recordFormats = (RecordFormats)Mockito.mock(RecordFormats.class);
        RecordFormat propertyKeyTokenFormat = this.getRecordFormatMock(maxPropertyKeyId);
        RecordFormat labelTokenFormat = this.getRecordFormatMock(maxLabelId);
        RecordFormat relationshipTypeTokenFormat = this.getRecordFormatMock(maxRelationshipTypeId);
        RecordFormat relationshipGroupTokenFormat = this.getRecordFormatMock(maxRelationshipGroupId);
        Mockito.when((Object)recordFormats.propertyKeyToken()).thenReturn((Object)propertyKeyTokenFormat);
        Mockito.when((Object)recordFormats.labelToken()).thenReturn((Object)labelTokenFormat);
        Mockito.when((Object)recordFormats.relationshipTypeToken()).thenReturn((Object)relationshipTypeTokenFormat);
        Mockito.when((Object)recordFormats.relationshipGroup()).thenReturn((Object)relationshipGroupTokenFormat);
        return recordFormats;
    }

    private RecordFormat getRecordFormatMock(long maxId) {
        RecordFormat recordFormat = (RecordFormat)Mockito.mock(RecordFormat.class);
        Mockito.when((Object)recordFormat.getMaxId()).thenReturn((Object)maxId);
        return recordFormat;
    }

    private Randoms getRandoms() {
        return new Randoms(this.randomRule.random(), Randoms.DEFAULT);
    }

    private InputNodeCacheWriter getNodeCacher(RecordFormats recordFormats) {
        return new InputNodeCacheWriter((StoreChannel)Mockito.mock(StoreChannel.class), (StoreChannel)Mockito.mock(StoreChannel.class), recordFormats, 100);
    }

    private InputRelationshipCacheWriter getRelationshipCacher(RecordFormats recordFormats) {
        return new InputRelationshipCacheWriter((StoreChannel)Mockito.mock(StoreChannel.class), (StoreChannel)Mockito.mock(StoreChannel.class), recordFormats, 100);
    }
}

