/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.GroupCache;

public class GroupCacheTest {
    @Test
    public void shouldHandleSingleByteCount() {
        int max = 256;
        GroupCache cache = GroupCache.select((NumberArrayFactory)NumberArrayFactory.HEAP, (int)100, (int)max);
        this.assertSetAndGet(cache, 10L, 45);
        this.assertSetAndGet(cache, 100L, 145);
        this.assertSetAndGet(cache, 1000L, 245);
        try {
            cache.set(10000L, 345);
            Assert.fail((String)"Shouldn't handle that");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void shouldSwitchToTwoByteVersionBeyondSingleByteGroupIds() {
        int max = 257;
        GroupCache cache = GroupCache.select((NumberArrayFactory)NumberArrayFactory.HEAP, (int)100, (int)max);
        this.assertSetAndGet(cache, 10L, 123);
        this.assertSetAndGet(cache, 100L, 1234);
        this.assertSetAndGet(cache, 1000L, 12345);
        this.assertSetAndGet(cache, 10000L, 65535);
        try {
            cache.set(100000L, 123456);
            Assert.fail((String)"Shouldn't handle that");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private void assertSetAndGet(GroupCache cache, long nodeId, int groupId) {
        cache.set(nodeId, groupId);
    }
}

